c**************************************************************

      function sum_red_SMC(x, borne_X)

c Intgrale d'une fonction donnant le rougissement pour le
c SMC (voir aussi : ~/work/NEW_paper1/EBmV_distrib/SMC)

c Cette fonction prend ses valeurs dans l'intervalle [Xmin,Xmax]
c et renvoie une valeur entre 0. et 1.

c Si borne_X = 0 cela donne la valeur de l'integrale
c              1 cela donne la valeur la borne inf. de l'intervalle
c                de validit de la fonction
c              2 cela donne la valeur de la borne sup. de l'intervalle
c                de validit de la fonction 

c D. Cordier, septembre 2001.

      implicit none

      integer borne_X

      real*8 sum_red_SMC, x, xmin, xmax

      parameter( xmin= 0.06d0, xmax= 0.11d0 )

c     Cas o la fonction renvoit les bornes de sont intervalle
c     de validit :
      if ( (borne_X .ne. 0) .AND. (borne_X .ne. 1) .AND.
     &     (borne_X .ne. 2) ) then
         print*, 'Pb. dans ''sum_red_SMC'' !'
         stop
      end if
      if ( borne_X .eq. 1 ) then
         sum_red_SMC = xmin
         return
      end if
      if ( borne_X .eq. 2 ) then
         sum_red_SMC = xmax
         return
      end if
c     -----------------------
      if ( x .lt. xmin ) then
         print*, 'Pb. dans ''sum_red_SMC'' : x .lt. xmin'
         stop
      end if
      if ( x .gt. xmax ) then
         print*, 'Pb. dans ''sum_red_SMC'' : x .gt. xmax'
         stop
      end if
c     -----------------------
      sum_red_SMC = ( .3123750000e-6*exp(266.6666667*x-.3813333334)*x**4
     &               -.1421306250e-6*exp(266.6666667*x-.3813333334)*x**3
     &               +.2427739453e-7*exp(266.6666667*x-.3813333334)*x**2
     &               -.1845164959e-8*exp(266.6666667*x-.3813333334)*x
     &               +.5265419234e-10*exp(266.6666667*x-.3813333334)
     &               -.163315490e-4)/0.005539268451d0

      return 

      end
