c**************************************************************

      function sum_red_LMC(x, borne_X)

c Intgrale d'une fonction donnant le rougissement pour le
c LMC (voir aussi : ~/work/NEW_paper1/EBmV_distrib/LMC)

c Cette fonction prend ses valeurs dans l'intervalle [Xmin,Xmax]
c et renvoie une valeur entre 0. et 1.

c Si borne_X = 0 cela donne la valeur de l'integrale
c              1 cela donne la valeur la borne inf. de l'intervalle
c                de validit de la fonction
c              2 cela donne la valeur de la borne sup. de l'intervalle
c                de validit de la fonction 

c D. Cordier, septembre 2001.

      implicit none

      integer borne_X

      real*8 sum_red_LMC, x, xmin, xmax

      parameter( xmin= 0.09d0, xmax= 0.23d0 )

c     Cas o la fonction renvoit les bornes de sont intervalle
c     de validit :
      if ( (borne_X .ne. 0) .AND. (borne_X .ne. 1) .AND.
     &     (borne_X .ne. 2) ) then
         print*, 'Pb. dans ''sum_red_LMC'' !'
         stop
      end if
      if ( borne_X .eq. 1 ) then
         sum_red_LMC = xmin
         return
      end if
      if ( borne_X .eq. 2 ) then
         sum_red_LMC = xmax
         return
      end if
c     -----------------------
      if ( x .lt. xmin ) then
         print*, 'Pb. dans ''sum_red_LMC'' : x .lt. xmin'
         stop
      end if
      if ( x .gt. xmax ) then
         print*, 'Pb. dans ''sum_red_LMC'' : x .gt. xmax'
         stop
      end if
c     -----------------------
      sum_red_LMC = (-2.531250000*exp(-88.88888889*x+17.69777778)*x**4
     &              +.7973437500*exp(-88.88888889*x+17.69777778)*x**3
     &              -.9610839844e-1*exp(-88.88888889*x+17.69777778)*x**2
     &              +.5218686035e-2*exp(-88.88888889*x+17.69777778)*x
     &              -.1073650946e-3*exp(-88.88888889*x+17.69777778)
     &              +.15843373e-1)/.01575528161d0

      return 

      end
