c============================================================

      function sig_min_V_SMC( V )

c Fonction donnant la valeur minimale de l'cart-type 
c des mesures de mangitudes B en fonction de la magnitude
c (V ici).

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 20 )

      real*8 sig_min_V_SMC, tV(1:nvalues), tSig_min(1:nvalues), V, 
     +       bidon, V_min, V_max

      data tV/1.227500E+01,1.282500E+01,1.337500E+01,
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,
     + 2.052500E+01,2.107500E+01,2.162500E+01,2.217500E+01,
     + 2.272500E+01/

      data tSig_min/6.045455E-03,6.045455E-03,6.045455E-03,
     + 6.045455E-03,6.045455E-03,6.045455E-03,5.787879E-03,
     + 5.787879E-03,6.477273E-03,7.212121E-03,8.250000E-03,
     + 1.009091E-02,1.229545E-02,1.648485E-02,2.656061E-02,
     + 3.756566E-02,5.938384E-02,1.166091E-01,2.507579E-01,
     + 4.586271E-01/

c Initialisation :
      V_min = tV(1)
      V_max = tV(nvalues)
      if ( V .le. V_min )  then
         sig_min_V_SMC = tSig_min(1)
         return
      end if
      if ( V .ge. V_max ) then
         sig_min_V_SMC = tSig_min(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_min, tV, nvalues, V, sig_min_V_SMC, bidon)

      sig_min_V_SMC = abs( sig_min_V_SMC )

      return

      end
