c============================================================

      function sig_min_V_LMC( V )

c Fonction donnant la valeur minimale de l'cart-type 
c des mesures de mangitudes B en fonction de la magnitude
c (V ici).

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 20 )

      real*8 sig_min_V_LMC, tV(1:nvalues), tSig_min(1:nvalues), V, 
     +       bidon, V_min, V_max

      data tV/1.227500E+01,1.282500E+01,1.337500E+01,
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,
     + 2.052500E+01,2.107500E+01,2.162500E+01,2.217500E+01,
     + 2.272500E+01/

      data tSig_min/7.857143E-03,7.857143E-03,7.857143E-03,
     + 7.857143E-03,7.857143E-03,7.404762E-03,7.063492E-03,
     + 6.984127E-03,7.297619E-03,8.412698E-03,1.035714E-02,
     + 1.312698E-02,1.764286E-02,2.442857E-02,3.838889E-02,
     + 5.694180E-02,9.267196E-02,1.875714E-01,3.514606E-01,
     + 5.251235E-01/

c Initialisation :
      V_min = tV(1)
      V_max = tV(nvalues)
      if ( V .le. V_min )  then
         sig_min_V_LMC = tSig_min(1)
         return
      end if
      if ( V .ge. V_max ) then
         sig_min_V_LMC = tSig_min(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_min, tV, nvalues, V, sig_min_V_LMC, bidon)

      sig_min_V_LMC = abs( sig_min_V_LMC )

      return

      end
