c============================================================

      function sig_min_B_SMC( B )

c Fonction donnant la valeur minimale de l'cart-type 
c des mesures de mangitudes B en fonction de la magnitude
c (B ici).

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 20 )

      real*8 sig_min_B_SMC, tB(1:nvalues), tSig_min(1:nvalues), B, 
     +       bidon, B_min, B_max

      data tB/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,2.162500E+01,2.217500E+01,   
     + 2.272500E+01/

      data tSig_min/7.883721E-03,7.883721E-03,7.883721E-03,
     + 7.883721E-03,6.818182E-03,5.977273E-03,5.454545E-03,
     + 5.515152E-03,5.545455E-03,6.151515E-03,6.704545E-03,
     + 7.606061E-03,8.454545E-03,1.051515E-02,1.434848E-02,
     + 2.117172E-02,2.979798E-02,5.476364E-02,1.254545E-01,
     + 3.508539E-01/

c Initialisation :
      B_min = tB(1)
      B_max = tB(nvalues)
      if ( B .le. B_min )  then
         sig_min_B_SMC = tSig_min(1)
         return
      end if
      if ( B .ge. B_max ) then
         sig_min_B_SMC = tSig_min(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_min, tB, nvalues, B, sig_min_B_SMC, bidon)

      sig_min_B_SMC = abs( sig_min_B_SMC )

      return

      end
