c============================================================

      function sig_min_B_LMC( B )

c Fonction donnant la valeur minimale de l'cart-type 
c des mesures de mangitudes B en fonction de la magnitude
c (B ici).

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 20 )

      real*8 sig_min_B_LMC, tB(1:nvalues), tSig_min(1:nvalues), B, 
     +       bidon, B_min, B_max

      data tB/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,2.162500E+01,2.217500E+01,   
     + 2.272500E+01/

      data tSig_min/8.666667E-03,8.666667E-03,8.666667E-03,
     + 8.666667E-03,8.666667E-03,8.666667E-03,8.587302E-03,
     + 8.428571E-03,8.857143E-03,9.507937E-03,1.129762E-02,
     + 1.322222E-02,1.533333E-02,1.849206E-02,2.603968E-02,
     + 3.717989E-02,4.991534E-02,9.849524E-02,2.272804E-01,
     + 4.672857E-01/

c Initialisation :
      B_min = tB(1)
      B_max = tB(nvalues)
      if ( B .le. B_min )  then
         sig_min_B_LMC = tSig_min(1)
         return
      end if
      if ( B .ge. B_max ) then
         sig_min_B_LMC = tSig_min(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_min, tB, nvalues, B, sig_min_B_LMC, bidon)

      sig_min_B_LMC = abs( sig_min_B_LMC )

      return

      end
