c============================================================

      function sig_max_V_SMC( V )

c Fonction donnant la valeur la plus probable pour l'cart-type
c en fonction de la magnitude V.

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 18 )

      real*8 sig_max_V_SMC, tV(1:nvalues), tSig_max(1:nvalues), V, 
     +       bidon, V_min, V_max

      data tV/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,
     + 2.272500E+01/
c2.162500E+01,2.217500E+01,   
c     + 2.272500E+01/

      data tSig_max/8.787879E-03,8.787879E-03,8.787879E-03,
     + 9.431818E-03,9.696970E-03,9.090909E-03,9.393939E-03,
     + 1.000000E-02,1.022727E-02,1.060606E-02,1.397727E-02,
     + 2.000000E-02,2.568182E-02,3.818182E-02,5.977273E-02,
     + 8.974747E-02,1.447475E-01,
     + 0.500000E+00/

c1.828636E-01,1.753030E-01,
c     + 1.736364E-01/

c Initialisation :
      V_min = tV(1)
      V_max = tV(nvalues)
      if ( V .le. V_min )  then
         sig_max_V_SMC = tSig_max(1)
         return
      end if
      if ( V .ge. V_max ) then
         sig_max_V_SMC = tSig_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_max, tV, nvalues, V, sig_max_V_SMC, bidon)

      sig_max_V_SMC = abs( sig_max_V_SMC )

      return

      end
