c============================================================

      function sig_max_V_LMC( V )

c Fonction donnant la valeur la plus probable pour l'cart-type
c en fonction de la magnitude V.

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 18 )

      real*8 sig_max_V_LMC, tV(1:nvalues), tSig_max(1:nvalues), V, 
     +       bidon, V_min, V_max

      data tV/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,
     + 2.272500E+01/
c2.162500E+01,2.217500E+01,   
c     + 2.272500E+01/

      data tSig_max/2.633333E-02,1.365854E-02,1.039683E-02,
     + 9.761905E-03,9.841270E-03,9.821429E-03,9.841270E-03,
     + 1.000000E-02,1.023810E-02,1.063492E-02,1.636905E-02,
     + 2.246032E-02,3.154762E-02,4.714286E-02,7.682540E-02,
     + 1.125132E-01,1.714021E-01,
     + 0.600000E+00/
c1.855238E-01,1.860847E-01,
c     + 1.866667E-01/

c Initialisation :
      V_min = tV(1)
      V_max = tV(nvalues)
      if ( V .le. V_min )  then
         sig_max_V_LMC = tSig_max(1)
         return
      end if
      if ( V .ge. V_max ) then
         sig_max_V_LMC = tSig_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_max, tV, nvalues, V, sig_max_V_LMC, bidon)

      sig_max_V_LMC = abs( sig_max_V_LMC )

      return

      end
