c============================================================

      function sig_max_B_SMC( B )

c Fonction donnant la valeur minimale de l'cart-type 
c des mesures de mangitudes B en fonction de la magnitude
c (B ici).

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 18 )

      real*8 sig_max_B_SMC, tB(1:nvalues), tSig_max(1:nvalues), B, 
     +       bidon, B_min, B_max

      data tB/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,
     + 2.272500E+01/

c2.162500E+01,2.217500E+01,   
c     + 2.272500E+01/

      data tSig_max/8.636364E-03,8.636364E-03,8.636364E-03,
     + 8.636364E-03,9.090909E-03,9.204545E-03,9.696970E-03,
     + 1.030303E-02,1.068182E-02,1.030303E-02,1.625000E-02,
     + 2.318182E-02,2.897727E-02,4.333333E-02,6.818182E-02,
     + 9.510101E-02,1.490909E-01,
     +0.400000E+00/

c1.753636E-01,0.220114E+00,
c     + 0.260245E+00/

c Initialisation :
      B_min = tB(1)
      B_max = tB(nvalues)
      if ( B .le. B_min )  then
         sig_max_B_SMC = tSig_max(1)
         return
      end if
      if ( B .ge. B_max ) then
         sig_max_B_SMC = tSig_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_max, tB, nvalues, B, sig_max_B_SMC, bidon)

      sig_max_B_SMC = abs( sig_max_B_SMC )

      return

      end
