c============================================================

      function sig_max_B_LMC( B )

c Fonction donnant la valeur minimale de l'cart-type 
c des mesures de mangitudes B en fonction de la magnitude
c (B ici).

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 18 )

      real*8 sig_max_B_LMC, tB(1:nvalues), tSig_max(1:nvalues), B, 
     +       bidon, B_min, B_max

      data tB/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,
     + 2.272500E+01/
c2.162500E+01,2.217500E+01,   
c     + 2.272500E+01/

      data tSig_max/2.261905E-02,1.828571E-02,
     + 1.309524E-02,1.178571E-02,1.182540E-02,1.202381E-02,
     + 1.206349E-02,1.285714E-02,1.375000E-02,1.714286E-02,
     + 2.125000E-02,2.555556E-02,3.619048E-02,5.269841E-02,
     + 8.138889E-02,1.185979E-01,1.738095E-01,
     + 0.550000E+00/
c1.845238E-01,
c     + 1.525926E-01,1.553439E-01/

c Initialisation :
      B_min = tB(1)
      B_max = tB(nvalues)
      if ( B .le. B_min )  then
         sig_max_B_LMC = tSig_max(1)
         return
      end if
      if ( B .ge. B_max ) then
         sig_max_B_LMC = tSig_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tSig_max, tB, nvalues, B, sig_max_B_LMC, bidon)

      sig_max_B_LMC = abs( sig_max_B_LMC )

      return

      end
