c**********************************************************

      function salpeter( idum, Mmin, Mmax, N_Mmax )

c Fonction gnrant une distribution de masse suivant une
c loi de type Salpeter.

c Le rsultat est exprim en unit solaire (masse)

c Cf. par exemple cahier XVIII p. 13

c D. Cordier, 16 octobre 2001.

c Entres : * idum   : entier NEGATIF d'initialisation de la
c                      fonction de tirage au sort "ran2"
c           * Mmin   : masse (en u. solaire) minimale
c           * Mmax   : masse (en u. solaire) maximale
c           * N_Mmax : nbr d'toiles dsires pour Mmax

      implicit none

      include 'synth_POP.para_com.f'

      integer idum

      real*8 salpeter, x, ran2, Mmin, Mmax, N_Mmax, int_Salpeter, x0

      external ran2, int_Salpeter
      
c     Un peu de scurit ...
      if ( idum .gt. 0 ) then
         idum = -1*idum
      end if


c     Tirage au sort d'une valeur alatoire entre 0.0 et 1.0
      x = ran2( idum )

c     On transforme la valeur de x pour qu'elle soir dans le domaine
c     couvert par int_Salpeter
      x = x * int_Salpeter(Mmax, Mmin, Mmax, N_Mmax )

      call dichot_Salpeter( x, int_Salpeter, Mmin, Mmax, x0, 
     #                      Mmin, Mmax, N_Mmax)

c     Affectation du rsultat
      salpeter = x0

      return

      end

