c************************************************************

      function red_SMC( ndum )

c Tire au sort une valeur du rougissement pour le
c SMC. La distribution de probabilit des valeurs de 
c rougissement a t tablie  partir des valeurs de rougissement
c dtermine par OGLE pour chacune des cphides du SMC.

c Voir ~/prog_perso/prog_aleatoire/test_distri.f
c et ~/work/NEW_paper1/EBmV_distrib

c D. Cordier, 21 septembre 2001.

      implicit none

      integer ndum

c     "sum_red_SMC" est la fonction qui donne sa "forme"  la 
c     distribution de probabilit.
      real*8 red_SMC, x, sum_red_SMC, b1, b2, x0

      real ran2

      external ran2, sum_red_SMC

c     Initialisation des bornes de l'intervalle de E(B-V) o
c     la distri. de proba. est dfinie.
      b1 = sum_red_SMC(0.d0,1) ! borne inf. de l'intervalle de validit
      b2 = sum_red_SMC(0.d0,2) ! borne sup. de l'intervalle de validit

c     Tirage au sort d'une valeur alatoire entre 0.0 et 1.0
      x = ran2( ndum )

c     Recherche de la valeur de E(B-V)  laquelle "x" correspond
      call dichot_SUM( x, sum_red_SMC, b1, b2, x0)

c     Affectation du rsultat
      red_SMC = x0

      return

      end
