c**********************************************************

      subroutine rand_Sig_V_SMC( V, SigV, idum )

c Routine gnrant une valeur d'erreur Sig (tire au sort suivant
c une distribution de proba. dduite des donnes OGLE 2 en fonction
c de la magnitude V.

c Spcifique au SMC

c D. Cordier, 27 septembre 2001.

      implicit none

      integer idum

      real*8 V, SigV, b1, b2, x, x0

      real*8 Sig_min, Sig_max, Pmax, as, bs ! df. cf. cahier XVII p. 48 verso
      real*8 prob_max_V_SMC, sig_max_V_SMC, sig_min_V_SMC, int_Sig,
     +       ran2

      real*8 deltaX, y
      integer i

      external prob_max_V_SMC, sig_max_V_SMC, sig_min_V_SMC,
     +         int_Sig, ran2
      
c     L'info. qui vient des donnes :
      Sig_min = sig_min_V_SMC( V )
      Sig_max = sig_max_V_SMC( V )
      Pmax    = prob_max_V_SMC( V )

      if ( idum .gt. 0 ) then
         idum = -1*idum
      end if

c     Calcul des constantes a et b (pour la dtermination
c     de ces expressions : voir cahier XVII vers la page 49)
      as = Pmax/256.*exp(4.)*(4./(Sig_max-Sig_min))**4
      bs = 4./(Sig_max-Sig_min)

c     Tirage au sort d'une valeur alatoire entre 0.0 et 1.0
      x = ran2( idum )

c     Recherche de la valeur de Sig  laquelle "x" correspond
c      call dichot_SUM( x, sum_red_SMC, b1, b2, x0)
      b1 = Sig_min
      b2 = 2.*Sig_max

c     On transforme la valeur de x pour qu'elle soir dans le domaine
c     couvert par int_Sig
      x = x * int_Sig( as, bs, Sig_min, b2 )

      call dichot_SIG( x, int_Sig, b1, b2, x0, as, bs, Sig_min)

c     Affectation du rsultat
      SigV = x0

      return

      end

