c============================================================

      function prob_max_V_SMC( V )

c Fonction donnant la valeur de la probabilit max. de
c l'cart-type sur les mesures de V, ceci en fct. de V.

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 19 )

      real*8 prob_max_V_SMC, tV(1:nvalues), tprob_max(1:nvalues), V, 
     +       bidon, V_min, V_max

      data tV/1.227500E+01,1.282500E+01,1.337500E+01,1.392500E+01,
     + 1.447500E+01,1.502500E+01,1.557500E+01,1.612500E+01,
     + 1.667500E+01,1.722500E+01,1.777500E+01,1.832500E+01,
     + 1.887500E+01,1.942500E+01,1.997500E+01,2.052500E+01,
     + 2.107500E+01,2.162500E+01,2.217500E+01/

      data tprob_max/7.166667E-01,6.158622E-01,5.007430E-01,
     + 4.724302E-01,3.968766E-01,3.679500E-01,3.718644E-01,
     + 3.511188E-01,3.449133E-01,3.860158E-01,3.131245E-01,
     + 3.077223E-01,2.805798E-01,1.899285E-01,1.310225E-01,
     + 9.576915E-02,8.127170E-02,2.753679E-01,7.936508E-01/

c Initialisation :
      V_min = tV(1)
      V_max = tV(nvalues)
      if ( V .le. V_min )  then
         prob_max_V_SMC = tprob_max(1)
         return
      end if
      if ( V .ge. V_max ) then
         prob_max_V_SMC = tprob_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tprob_max, tV, nvalues, V, prob_max_V_SMC,bidon)

      prob_max_V_SMC = abs( prob_max_V_SMC )

      return

      end
