c============================================================

      function prob_max_V_LMC( V )

c Fonction donnant la valeur de la probabilit max. de
c l'cart-type sur les mesures de V, ceci en fct. de V.

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 20 )

      real*8 prob_max_V_LMC, tV(1:nvalues), tprob_max(1:nvalues), V, 
     +       bidon, V_min, V_max

      data tV/1.227500E+01,1.282500E+01,1.337500E+01,
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,
     + 2.052500E+01,2.107500E+01,2.162500E+01,2.217500E+01,
     + 2.272500E+01/

      data tprob_max/8.166667E-01,6.700098E-01,6.220292E-01,
     + 5.445987E-01,4.952014E-01,4.853601E-01,4.422707E-01,
     + 3.805606E-01,3.115140E-01,3.438381E-01,3.143574E-01,
     + 3.273104E-01,2.390751E-01,1.643296E-01,1.129387E-01,
     + 8.418143E-02,1.208814E-01,5.273603E-01,1.000000E+00,
     + 1.000000E+00/

c Initialisation :
      V_min = tV(1)
      V_max = tV(nvalues)
      if ( V .le. V_min )  then
         prob_max_V_LMC = tprob_max(1)
         return
      end if
      if ( V .ge. V_max ) then
         prob_max_V_LMC = tprob_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tprob_max, tV, nvalues, V, prob_max_V_LMC,bidon)

      prob_max_V_LMC = abs( prob_max_V_LMC )

      return

      end
