c============================================================

      function prob_max_B_LMC( B )

c Fonction donnant la valeur de la probabilit max. de
c l'cart-type sur les mesures de B, ceci en fct. de B.

c Donnes sources : Fields Map d'OGLE 2

c D.C., 25 septembre 2001.

      implicit none

      integer nvalues

      parameter ( nvalues = 20 )

      real*8 prob_max_B_LMC, tB(1:nvalues), tprob_max(1:nvalues), B, 
     +       bidon, B_min, B_max

      data tB/1.227500E+01,1.282500E+01,1.337500E+01,   
     + 1.392500E+01,1.447500E+01,1.502500E+01,1.557500E+01,   
     + 1.612500E+01,1.667500E+01,1.722500E+01,1.777500E+01,   
     + 1.832500E+01,1.887500E+01,1.942500E+01,1.997500E+01,   
     + 2.052500E+01,2.107500E+01,2.162500E+01,2.217500E+01,   
     + 2.272500E+01/

      data tprob_max/8.214286E-01,7.942177E-01,5.788316E-01,
     + 5.066929E-01,3.797666E-01,3.587075E-01,2.823885E-01,
     + 2.564317E-01,2.165288E-01,1.975383E-01,2.219007E-01,
     + 2.169995E-01,1.707329E-01,1.358048E-01,1.029966E-01,
     + 7.830911E-02,1.069725E-01,2.794194E-01,6.164725E-01,
     + 9.375000E-01/

c Initialisation :
      B_min = tB(1)
      B_max = tB(nvalues)
      if ( B .le. B_min )  then
         prob_max_B_LMC = tprob_max(1)
         return
      end if
      if ( B .ge. B_max ) then
         prob_max_B_LMC = tprob_max(nvalues)
         return
      end if

c     -----------------
      call interpol_lin(tprob_max, tB, nvalues, B, prob_max_B_LMC,bidon)

      prob_max_B_LMC = abs( prob_max_B_LMC )

      return

      end
