c***********************************************************************
 
      subroutine interpol_quad( f, x, nx, x0, fx0, dfsdx )
 
c-----------------------------------------------------------------------
 
c Ce programme fournit f(x0) et df/dx](x0), f(x0) est obtenu par 
c interpolation parabolique.
 
c C'est une version de "int_ext_parab".

c Rq.: dans le choix des 3 plus proches voisins on n envisage pas le cas
c      ou x0 n est pas dans l intervalle couvert par les 3 plus proches
c      voisins ( et c est peut etre mieux comme cela!)
 
c ATTENTION: les x(j) doivent etre tous differents avec des valeurs
c            croissantes ou decroissantes.
 
c subroutines appelees: * resol_syst33
c                       * locate
 
c entrees: * f : tableau des valeurs de la fonction a interpolee
c          * x : tableau des nx valeurs de l abscisse
c          * x0: points ou on interpole ou extrapole
 
c sortie: * fx0: valeur approchee de la fonction en x0
c         * dfsdx: valeur approchee de la derivee en x0
 

c D. Cordier, novembre 2001.
 
      implicit none
 
      integer nx, j, i1
 
      real*8 f, x, x0, fx0, dfsdx, u, v, tab_u, a, dist_1, dist_2,
     &       alpha, beta, x1_d, xn_g, f1_d, fn_g
 
      dimension f(nx), x(nx), u(3), v(3), tab_u(3,3), a(3)
 
c Cas de l'extrapolation : on l'interdit

      if ( x(1) .lt. x(nx) ) then ! cas o les "x" sont croissant
         if ( (x0 .lt. x(1)) .OR. (x0.gt.x(nx)) ) then
            print*,' '
            print*, '>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
            print*, '>>> Pb. dans "interpol_quad" : '
            print*, '    l''extrapolation est interdite et on a :'
            print*, '    x(1)    = ', x(1)
            print*, '    x(2)    = ', x(2)
            print*, '            x0 = ', x0
            print*, '    x(nx-1) = ', x(nx-1)
            print*, '    x(nx)   = ', x(nx)
            print*, '<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<'
            print*, ' '
            stop
         end if
       else
          if ( (x0 .gt. x(1)) .OR. (x0.lt.x(nx)) ) then
            print*,' '
            print*, '>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
            print*, '>>> Pb. dans "interpol_quad" : '
            print*, '    l''extrapolation est interdite et on a :'
            print*, '    x(1)    = ', x(1)
            print*, '    x(2)    = ', x(2)
            print*, '            x0 = ', x0
            print*, '    x(nx-1) = ', x(nx-1)
            print*, '    x(nx)   = ', x(nx)
            print*, '<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<'
            print*, ' '
            stop
         end if
      end if

c Cas ou x(1) < x0 < x(nx)
 
      call locate(x, nx, x0, j)

      if ( j .eq. 1 ) then
         u(1)=x(1)
         u(2)=x(2)
         u(3)=x(3)
         v(1)=f(1)
         v(2)=f(2)
         v(3)=f(3)
         goto 100
      end if
 
      if ( (j .eq. nx-1) .OR. (j .eq. nx) ) then
         u(1)=x(nx-2)
         u(2)=x(nx-1)
         u(3)=x(nx)
         v(1)=f(nx-2)
         v(2)=f(nx-1)
         v(3)=f(nx)
         goto 100
      end if
 
      dist_1=abs(x(j-1)-x(j))
      dist_2=abs(x(j)-x(j+2))
 
      if ( dist_1 .le. dist_2 ) then
         u(1)=x(j-1)
         u(2)=x(j)
         u(3)=x(j+1)
         v(1)=f(j-1)
         v(2)=f(j)
         v(3)=f(j+1)
         goto 100
      else
         u(1)=x(j)
         u(2)=x(j+1)
         u(3)=x(j+2)
         v(1)=f(j)
         v(2)=f(j+1)
         v(3)=f(j+2)
         goto 100
      end if
 
c Construction du tableau tab_u
 
100   do i1= 1, 3, 1
         tab_u(i1,1)=(u(i1))**2
         tab_u(i1,2)=u(i1)
         tab_u(i1,3)=1.
      end do
 
c Resolution du systeme
 
      call resol_syst33( tab_u, a, v)
 
      fx0=a(1)*x0**2+a(2)*x0+a(3)
      dfsdx=(2.D+00)*a(1)*x0+a(2)
 
      return
 
      end
