c----------------------------------------------------------------

      subroutine  interpol_BV_ROT_save( filename, Ntot, rot, idum, 
     &                 n_mass, n_rec, ntracks, masse, filename_BV_tot )

c Obj. : On construit par interpolation des diffrents tracks
c        des trajets volutifs pour chaque valeur de masse
c        contenue dans "masse (i)"

c        Mthode d'interpolation : cf. cahier XVII p. 28-29.

c        Pour chaque masse on a donc un trajet sous la forme 
c        (B,V,ge,u). 
c           * pour une valeur de masse quelconque on interpole
c             par rapport  u sur la MS
c           * en dehors de la MS on interpole par rapport au
c             temps.

c        Chacun de ces trajets est ensuite interpol
c        tout les "Delta t".

c        Utilisation d'une simulation de l'effet de la ROTATION
c        (option "rot"). Cette possibilit reste trs exprimentale
c        et n'a pas vraiment de support physique. 
c
c        Le rsultat est stock dans un seul fichier

c Entres : * filename        : nom du fichier dans lequel sont inscrits
c                               les noms des fichiers B,V,ge
c           * Ntot            : Nombre total d'toiles avant mise en binaire
c                               et filtrage sur les erreurs
c           * rot             : .true. on utilise la rotation, .false. on ne le
c                               fait pas.
c           * idum            : initialisation des tirages au sort
c           * n_mass          : nombre de valeurs de masse
c           * masse           : tableau contenant toutes les valeurs de masse
c           * filename_BV_tot : nom du fichier o on va crire tous les couples
c                               (B,V)

c D. Cordier, mai-octobre 2001.

      implicit none

      include 'synth_POP.para_com.f'

      integer long, ifile, nfile, nl, idum, n_mass, i, ntracks,
     &        im, indice_m, Ntot, n_rec,  n_rec_2

      logical ilestla, rot

      real*8 delta_t, m(nl_max), B(nl_max), B1(nl_max), B2(nl_max), 
     &    V(nl_max), V1(nl_max), V2(nl_max), age(nl_max), age1(nl_max),
     &    age2(nl_max), Xc(nl_max), u(nl_max), u1(nl_max), u2(nl_max), 
     &    t, t_max, t_max1, t_max2, t_MSend1, t_MSend2, b0, v0, u0, 
     &    delta_u, delta_t_R, bidon, red_rot, rand_red_ROTATION, 
     &    masse(1:nsmax), track_temp(nbr_file_max, npt_track,4), 
     &    deltat, lamasse, m1, m2, t_1, t_2, b_1, b_2, v_1, v_2, tr1, 
     &    tr2, track_interpol(nsmax,npt_track,3), tau_TOT

      character filename*(nc_max), filename_BV_tot*(nc_max),
     &          file*(nc_max), file_temp*(nc_max)

      dimension file(1:nbr_file_max)

      external long, rand_red_ROTATION

c ... au cas o ...
      if ( idum .lt. 0 ) then
         idum = -1 * idum
      end if

c Nom du fichier dans lequel on va mettre tous les couples
c (B,V) pour le jeu complet de trajets volutifs.
      filename_BV_tot='BV_tot.BV'
      inquire(file=filename_BV_tot(:long(filename_BV_tot)),
     +        exist=ilestla)
      if ( ilestla ) then
c     Au cas accidentel o le fichier 'BV_tot.BV' existe on
c     l'efface !
         open(unit=1,status='unknown',file=
     +     filename_BV_tot(:long(filename_BV_tot)))
         close(1,status='delete')
      end if
c     -----------------------------------------------------
      inquire(file=filename(:long(filename)),exist=ilestla)
      if ( .NOT. ilestla ) then
         print*, 'Le fichier : ', filename(:long(filename))
         print*, 'est absent, on stoppe !'
         stop
      end if
      !>>>>>>>>>>>>>>>>>>>>
      open(unit=1,status='old',form='formatted',file=
     +     filename(:long(filename)))
      nfile=0
      do while ( .true. ) 
        nfile=nfile+1
        read(1,*,end=100) m(nfile)
        read(1,1000,end=100) file(nfile) ! On lit les noms des fichiers (B,V,ge)
                                         !  traiter.
        if ( nfile .gt. nbr_file_max ) then
           print*, 'Il y a trop de fichiers dans ', 
     +              filename(:long(filename))
           print*, 'Il faut augmenter la valeur du paramtre'
           print*, '<<nbr_file_max>> dans <<synth_POP.para_com.f>>'
           print*, 'On stoppe !'
           stop
        end if
 1000   format(A)
      end do

 100  nfile=nfile-1
      close(unit=1)
      !>>>>>>>>>>>>>>>>>>>>
      print*, ' '
      print*, '----------------------------------------------- '
      print*, ' * Il y a ', nfile, ' fichier(s)  traiter'
      print*, ' '
      print*, ' * Voici leurs noms :'
      print*, ' '
      do ifile= 1, nfile
         write(6,1000) file(ifile)
      end do
c      print*, ' '
c      print*, ' * Pas de temps utilis : ', delta_t
c      print*, ' '

      print*, ' * ... on traite ces fichiers ...'
      print*, ' '

c     =========================================================
c     On "reformate" chaque track avec un mme nombre de points
c     (npt_track cf. "synth_POP.para_com.f")
      print*, ' >>> reformatage '
      do ifile= 1, nfile
         file_temp=file(ifile)
         !xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
         inquire(file=file_temp(:long(file_temp)),exist=ilestla)
         if ( .NOT. ilestla ) then
            print*, 'Le fichier : ', file_temp(:long(file_temp))
            print*, 'est absent, on stoppe !'
            stop
         end if
         !xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
         open(unit=2,status='old',form='formatted',file=
     +        file_temp(:long(file_temp))) ! On ouvre un fichier (B,V,ge)
         write(6,1000) file(ifile)
         nl=0
         do while ( .true. ) ! on scanne le fichier jusqu'au bout <<<<<<<<<
            nl=nl+1
            read(2,2000,end=200) B(nl), V(nl), age(nl), Xc(nl)
            u(nl) = 1.d0-Xc(nl)/Xc(1)
c            print*, B(nl), V(nl), age(nl)
 2000       format(1p,4d16.6)
            if ( nl .gt. nl_max ) then
               print*, 'Dans le fichier : ', file_temp(:long(file_temp))
               print*, 'Il y a un nombre de modles suprieur '
               print*, 'nl_max = ', nl_max
               print*, 'il faut changer la valeur de ce paramtre !'
               print*, 'On stoppe !'
               stop
            end if
         end do
 200     close(unit=2)
         nl=nl-1
         t=age(1)
         t_max=age(nl)
         print*, '==> dans ce fichier, nmbre de modles : ', nl
         print*, '    Age_ini = ', t
         print*, '    Age_max = ', t_max

         ! On interpole pour avoir au final "npt_track" points par tracks
         deltat = (t_max-t)/(npt_track-1)
c         print*, 'deltat = ', deltat
         do i= 1, npt_track
c            print*, 'i = ', i
c            print*, 't = ', t
            call interpol_lin(B, age, nl, t, b0, bidon)
            call interpol_lin(V, age, nl, t, v0, bidon)
            call interpol_lin(u, age, nl, t, u0, bidon)
            if ( .NOT. rot ) then
c               write(1,3000) b0, v0
               track_temp(ifile,i,1) = b0
               track_temp(ifile,i,2) = v0
               track_temp(ifile,i,3) = t
               track_temp(ifile,i,4) = u0
            else
               red_rot = rand_red_ROTATION( idum )
               if ( t/t_max .lt. 0.5d0 ) then
                  red_rot = red_rot * (1.-2.*t/t_max)
                  v0 = v0 +    red_rot
                  b0 = b0 + 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               else
                  red_rot = red_rot * (2.*t/t_max-1.)
                  v0 = v0 -    red_rot
                  b0 = b0 - 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               end if
            end if
            t = t + deltat
         end do ! i
      end do

c     =========================================================
c     Pour chaque valeur de masse on construit un trajet volutif
c     interpol par rapport  ceux calculer par CESAM
      print*, ' >>> interpolation pour chaque masse'
      do im= 1, n_mass
         ! Valeur en cours de la masse
         lamasse = masse(im)
c         print*, 'lamasse = ', lamasse
         ! On cherche les deux valeurs de masse adjacentes
         do ifile= 1, nfile
            if ( (m(ifile) .le. lamasse   ) .AND. 
     &           (lamasse  .le. m(ifile+1))       ) then
               indice_m = ifile
            end if
         end do ! ifile
            m1 = m(indice_m)
            m2 = m(indice_m+1)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c EN CHANTIER EN CHANTIER EN CHANTIER EN CHANTIER EN CHANTIER EN CHANTIER
         ! Dt. des ges max. calculs sur chaque track
         t_max1 = track_temp( indice_m, npt_track, 3)
         t_max2 = track_temp( indice_m+1, npt_track, 3)

         ! Dt. des ges des fin de Main Sequence
         do i= 1, npt_track
            B1(i)   = track_temp( indice_m, npt_track, 1)
            V1(i)   = track_temp( indice_m, npt_track, 2)
            age1(i) = track_temp( indice_m, npt_track, 3)
            u1(i)   = track_temp( indice_m, npt_track, 4)
         
            B2(i)   = track_temp( indice_m+1, npt_track, 1)
            V2(i)   = track_temp( indice_m+1, npt_track, 2)
            age2(i) = track_temp( indice_m+1, npt_track, 3)
            u2(i)   = track_temp( indice_m+1, npt_track, 4)
         end do
         call interpol_lin(age1,u1,npt_track,u_lim,t_MSend1,bidon)
         call interpol_lin(age2,u2,npt_track,u_lim,t_MSend2,bidon)

         ! Interpolation en masse par rapport  "u" sur la Main Sequence
         delta_u = u_lim / (npt_MS-1)
         u0 = 0.d+00

         do i= 1, npt_MS
            call interpol_lin(B1,u1,npt_track,u0,b_1,bidon)
            call interpol_lin(V1,u1,npt_track,u0,v_1,bidon)
            call interpol_lin(age1,u1,npt_track,u0,t_1,bidon)

            call interpol_lin(B2,u2,npt_track,u0,b_2,bidon)
            call interpol_lin(V2,u2,npt_track,u0,v_2,bidon)
            call interpol_lin(age2,u2,npt_track,u0,t_2,bidon)

            t  = (t_2-t_1)/(m2-m1) * (lamasse-m1) + t_1
            b0 = (b_2-b_1)/(m2-m1) * (lamasse-m1) + b_1
            v0 = (v_2-v_1)/(m2-m1) * (lamasse-m1) + v_1

            u0 = u0 + delta_u

            track_interpol( im, i, 1 ) = b0
            track_interpol( im, i, 2 ) = v0
            track_interpol( im, i, 3 ) = t
         end do ! i= 1, npt_MS

            ! Interpolation temporelle au-del de la Main Sequence
            ! * Calcul des temps restants sur chaque track
            tr1 = t_max1 - t_MSend1
            tr2 = t_max2 - t_MSend2
            ! * Dt. du pas de temps utilis en dehors de la MS
            delta_t_R = min(tr1,tr2)/NptR
            t = max(t_MSend1,t_MSend2) + delta_t_R
            i = npt_MS
            
            do while ( t .le. min(t_max1,t_max2 ) )
               call interpol_lin(B1,age1,npt_track,t,b_1,bidon)
               call interpol_lin(V1,age1,npt_track,t,v_1,bidon)

               call interpol_lin(B2,age2,npt_track,t,b_2,bidon)
               call interpol_lin(V2,age2,npt_track,t,v_2,bidon)

               i = i +1

               b0 = (b_2-b_1)/(m2-m1) * (lamasse-m1) + b_1
               v0 = (v_2-v_1)/(m2-m1) * (lamasse-m1) + v_1

                track_interpol( im, i, 1 ) = b0
                track_interpol( im, i, 2 ) = v0
                track_interpol( im, i, 3 ) = t

                t = t + delta_t_R
            end do

c EN CHANTIER EN CHANTIER EN CHANTIER EN CHANTIER EN CHANTIER EN CHANTIER
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      end do ! im

c     =========================================================
c     On dtermine les valeurs tau(i) des dures des MS pour
c     chaque tracks, on en fait la somme tau_TOT
      tau_TOT = 0.d0
      do im= 1, n_mass
         t       = track_interpol(im,1,3) ! ge initial
         t_max   = track_interpol(im,npt_track,3) ! ge max.
         tau_TOT = tau_TOT + t_max - t
      end do

c     =========================================================
c     Dtermination de "Delta_t"
      delta_t = tau_TOT/Ntot

c TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST 
c      open(1,status='unknown',form='formatted',file='TEST.dat')
c      do im= 1, n_mass
c         do i= 1, npt_track
c            write(1,*) track_interpol(im,i,1)-track_interpol(im,i,2),
c     &                 track_interpol(im,i,2)
c         end do
c      end do
c      close(1)
c      print*, 'TEST termin !'
c      print*, 'Fichier TEST.dat crit !'
c      stop
c
c TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST 

c     =========================================================
c     On interpole temporellement chaque trajet volutif cr
c      l'tape prcdente (un track de "npt_track" points).
c     On stocke les rsultats dans un seul fichier qui sera 
c     rutilis ensuite par les routines suivantes.
      print*, ' >>> interpolation temporelle !'
      ! Dtermination du nombre d'enregistrement dans le fichier
      n_rec = 0
      do im= 1, n_mass
         t     = track_interpol(im,1,3) ! ge initial
         t_max = track_interpol(im,npt_track,3) ! ge max.
         do while ( t .lt. t_max )
            n_rec = n_rec + 1
            t = t + delta_t
         end do ! while ( t .lt. t_max )
      end do ! im
      ! Interpolation et criture
      n_rec_2 = 0
      open(3,status='new',access='direct',recl=n_rec,form='formatted',
     +     file=filename_BV_tot(:long(filename_BV_tot)))
      do im= 1, n_mass
         t     = track_interpol(im,1,3) ! ge initial
         t_max = track_interpol(im,npt_track,3) ! ge max.
         do while ( t .lt. t_max )
            do i= 1, npt_track
               B(i)   = track_interpol(im,i,1)
               V(i)   = track_interpol(im,i,2)
               age(i) = track_interpol(im,i,3)
            end do
            call interpol_lin(B, age, npt_track, t, b0, bidon)
            call interpol_lin(V, age, npt_track, t, v0, bidon)
            n_rec_2 = n_rec_2 + 1
            write(3,3000,rec=n_rec_2) b0, v0
 3000       format(1p2d16.6)
            t = t + delta_t
         end do ! while ( t .lt. t_max )
      end do ! im

      close(3)

      print*, ' '
      print*, ' * Fichier : ', filename_BV_tot(:long(filename_BV_tot)),
     &        ' crit !'
      print*, '   On y a crit : ', n_rec, ' couples (B,V)'
      print*, ' '
      print*, ' * Lecture et interpolations termines !'
      print*, ' '

c TEST TEST TEST
c      stop
c TEST TEST TEST

      return

      end
