c-------------------------------------------------------------------------

      subroutine  interpol_BV_ROT_quad( filename, Ntot, rot, idum, 
     &                 n_mass, n_rec, ntracks, masse, filename_BV_tot )

c Obj. : On construit par interpolation des diffrents tracks
c        des trajets volutifs pour chaque valeur de masse
c        contenue dans "masse (i)"

c        Interpolation en masse en caractrisant chaque stade volutif
c        par la valeur de ge/Tau_MS (Tau_MS : temps total pass sur
c        la squence principale).

c        METHODE D'INTERPOLATION : 

c               (1) quadratique (en y=a*x^2+b*x+c) qui permet
c                   d'atteindre de trs bonnes prcisions sur
c                   Tau_MS interpol.
c
c               (2) linaire sur un trajet volutif
c

c Algorithme : cf. cahier XVIII p. 40.

c        Chacun de ces trajets est ensuite interpol
c        tout les "Delta t".

c        Utilisation d'une simulation de l'effet de la ROTATION
c        (option "rot"). Cette possibilit reste trs exprimentale
c        et n'a pas vraiment de support physique. 
c
c        Le rsultat est stock dans un seul fichier

c Entres : * filename        : nom du fichier dans lequel sont inscrits
c                               les noms des fichiers B,V,ge
c           * Ntot            : Nombre total d'toiles avant mise en binaire
c                               et filtrage sur les erreurs
c           * rot             : .true. on utilise la rotation, .false. on ne le
c                               fait pas.
c           * idum            : initialisation des tirages au sort
c           * n_mass          : nombre de valeurs de masse
c           * masse           : tableau contenant toutes les valeurs de masse
c           * filename_BV_tot : nom du fichier o on va crire tous les couples
c                               (B,V)

c D. Cordier, 19 novembre 2001.

      implicit none

      include 'synth_POP.para_com.f'

      integer i, j, k, long, ifile, nfile, nl, idum, n_mass, ntracks,
     &        im, indice_m, Ntot, n_rec,  n_rec_2, nmasse, im1, im2,
     &        im3, nm, imini, ifinal

      logical ilestla, rot

      real*8 delta_t, m(nl_max), B(nl_max), V(nl_max),  age(nl_max),
     & Xc(nl_max), u(nl_max), t, t_max, b0, v0, u0, bidon, red_rot, 
     & rand_red_ROTATION, masse(1:nsmax), track_temp(nbr_file_max, 
     & npt_track,4), deltat, lamasse, track_interpol(nsmax,npt_track,3), 
     & tau_TOT, delta_u, Bm(3), Vm(3), agem(3), massss(3), umax_min, 
     & tau_file_MS(1:nbr_file_max), age_red(1:3), Xc_red(1:3)

      character filename*(nc_max), filename_BV_tot*(nc_max),
     &          file*(nc_max), file_temp*(nc_max)

      dimension file(1:nbr_file_max)

      external long, rand_red_ROTATION

c ... au cas o ...
      if ( idum .lt. 0 ) then
         idum = -1 * idum
      end if

c Nom du fichier dans lequel on va mettre tous les couples
c (B,V) pour le jeu complet de trajets volutifs.
      filename_BV_tot='BV_tot.BV'
      inquire(file=filename_BV_tot(:long(filename_BV_tot)),
     +        exist=ilestla)
      if ( ilestla ) then
c     Au cas accidentel o le fichier 'BV_tot.BV' existe on
c     l'efface !
         open(unit=1,status='unknown',file=
     +     filename_BV_tot(:long(filename_BV_tot)))
         close(1,status='delete')
      end if
c     -----------------------------------------------------
      inquire(file=filename(:long(filename)),exist=ilestla)
      if ( .NOT. ilestla ) then
         print*, 'Le fichier : ', filename(:long(filename))
         print*, 'est absent, on stoppe !'
         stop
      end if
      !>>>>>>>>>>>>>>>>>>>>
      open(unit=1,status='old',form='formatted',file=
     +     filename(:long(filename)))
      nfile=0
      do while ( .true. ) 
        nfile=nfile+1
        read(1,*,end=100) m(nfile)
        read(1,1000,end=100) file(nfile) ! On lit les noms des fichiers (B,V,ge)
                                         !  traiter.
        if ( nfile .gt. nbr_file_max ) then
           print*, 'Il y a trop de fichiers dans ', 
     +              filename(:long(filename))
           print*, 'Il faut augmenter la valeur du paramtre'
           print*, '<<nbr_file_max>> dans <<synth_POP.para_com.f>>'
           print*, 'On stoppe !'
           stop
        end if
 1000   format(A)
      end do

 100  nfile=nfile-1
      close(unit=1)
      ! Un peu se scurit ...+++++++++++++++++++++++++++++++++++
      if ( nfile .lt. 3 ) then
         print*, 'Pb. dans "interpol_BV_ROT_quad" :'
         print*, 'nfile= ', nfile, ' < 3'
         print*, 'Donc impossible de mener des interpolations'
         print*, 'quadratiques (paraboliques)'
         stop
      end if
      ! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      !>>>>>>>>>>>>>>>>>>>>
      print*, ' '
      print*, '----------------------------------------------- '
      print*, ' * Il y a ', nfile, ' fichier(s)  traiter'
      print*, ' '
      print*, ' * Voici leurs noms :'
      print*, ' '
      do ifile= 1, nfile
         write(6,1000) file(ifile)
      end do

      print*, ' * ... on traite ces fichiers ...'
      print*, ' '

c     =========================================================
c     On "reformate" chaque track avec un mme nombre de points
c     ==>> On change de pas temporel en dehors de la MS afin d'y
c          avoir galement des points.
      print*, ' >>> reformatage '
      do ifile= 1, nfile
         file_temp=file(ifile)
         !xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
         inquire(file=file_temp(:long(file_temp)),exist=ilestla)
         if ( .NOT. ilestla ) then
            print*, 'Le fichier : ', file_temp(:long(file_temp))
            print*, 'est absent, on stoppe !'
            stop
         end if
         !xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
         open(unit=2,status='old',form='formatted',file=
     +        file_temp(:long(file_temp))) ! On ouvre un fichier (B,V,ge)
         write(6,1000) file(ifile)
         nl=0
         do while ( .true. ) ! on scanne le fichier jusqu'au bout <<<<<<<<<
            nl=nl+1
            ! ATTENTION : bien vrifier que les fichiers de la grille sont
            ! bien dans ce format et en particulier que Xc soit bien une
            ! fraction massique au centre !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            read(2,2000,end=200) B(nl), V(nl), age(nl), Xc(nl)
            !print*, B(nl), V(nl), age(nl), Xc(nl)
 2000       format(1p,4d16.6)
            if ( nl .gt. nl_max ) then
               print*, 'Dans le fichier : ', file_temp(:long(file_temp))
               print*, 'Il y a un nombre de modles suprieur '
               print*, 'nl_max = ', nl_max
               print*, 'il faut changer la valeur de ce paramtre !'
               print*, 'On stoppe !'
               stop
            end if
         end do
 200     close(unit=2)
         nl=nl-1
         t=age(1)
         t_max=age(nl)
         print*, '==> dans ce fichier, nmbre de modles : ', nl
         print*, '    Age_ini = ', t
c         print*, 'age(nl-2)= ', age(nl-2), ', age(nl-1)= ', age(nl-1)
         print*, '    Age_max = ', t_max

c Dtermination de Tau_MS (temps pass sur la Main Sequence) pour les diffretns trajets
c         call interpol_quad( age, Xc, nl, Xc_final, tau_file_MS(ifile), 
c     &                       bidon)
c         print*, 'nl       = ', nl
c         print*, 'Xc_final = ', Xc_final
         call locate(Xc,nl,Xc_final,ifinal)
c         print*, 'ifinal   = ', ifinal
         if ( ifinal .eq. 1) then
            age_red(1) = age(1)
            age_red(2) = age(2)
            age_red(3) = age(3)

            Xc_red(1)  = Xc(1)
            Xc_red(2)  = Xc(2)
            Xc_red(3)  = Xc(3)
         else
            age_red(1) = age(ifinal-1)
            age_red(2) = age(ifinal)
            age_red(3) = age(ifinal+1)

            Xc_red(1)  = Xc(ifinal-1)
            Xc_red(2)  = Xc(ifinal)
            Xc_red(3)  = Xc(ifinal+1)
         end if

         call interpol_quad( age_red, Xc_red, 3, Xc_final, 
     &                       tau_file_MS(ifile), bidon)
         tau_file_MS(ifile) = tau_file_MS(ifile) - age(1)

         !print*, 'tau_file_MS(',ifile,')= ', tau_file_MS(ifile)

c        ================================================================
         ! On interpole pour avoir au final "npt_track" points par tracks
         ! ______________________________________
         ! (1) Interpolation sur la Main Sequence
         deltat = tau_file_MS(ifile)/(npt_MS-1)
         t = age(1)
         do i= 1, npt_MS
            call int_lin_synthP(B, age, nl, t, b0, bidon)
            call int_lin_synthP(V, age, nl, t, v0, bidon)
            u0 = (t-age(1))/tau_file_MS(ifile)
            if ( .NOT. rot ) then
c               write(1,3000) b0, v0
               track_temp(ifile,i,1) = b0
               track_temp(ifile,i,2) = v0
               track_temp(ifile,i,3) = t
               track_temp(ifile,i,4) = u0
            else
               red_rot = rand_red_ROTATION( idum )
               if ( t/t_max .lt. 0.5d0 ) then
                  red_rot = red_rot * (1.-2.*t/t_max)
                  v0 = v0 +    red_rot
                  b0 = b0 + 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               else
                  red_rot = red_rot * (2.*t/t_max-1.)
                  v0 = v0 -    red_rot
                  b0 = b0 - 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               end if
            end if
            t = t + deltat
         end do ! i
         ! _______________________________________________
         ! (2) Interpolation en dehors de la Main Sequence
         deltat = (t_max - (age(1)+tau_file_MS(ifile)) )/npt_post
c         print*, 'deltat = ', deltat
         t = age(1) + tau_file_MS(ifile) + deltat
         do i= npt_MS+1,  npt_MS+npt_post
            call int_lin_synthP(B, age, nl, t, b0, bidon)
            call int_lin_synthP(V, age, nl, t, v0, bidon)
c            if ( (m(ifile) .eq. 3.0d0) .AND. 
c     &           (i .eq. npt_MS+npt_post) ) then
c               print*, 'm(ifile)= ', m(ifile)
c               print*, 'i= ', i
c               print*, 'b0= ', b0
c               print*, 'v0= ', v0
c               print*, 'B(nl) = ', B(nl), ' B(nl-1) = ', B(nl-1)
c               print*, 'V(nl) = ', V(nl), ' V(nl-1) = ', V(nl-1)
c               print*, 'age(nl) = ', age(nl), 'age(nl-1) = ', age(nl-1) 
c               print*, 't  ', t
c               pause
c            end if

            u0 = (t-age(1))/tau_file_MS(ifile)
            if ( .NOT. rot ) then
c               write(1,3000) b0, v0
               track_temp(ifile,i,1) = b0
               track_temp(ifile,i,2) = v0
               track_temp(ifile,i,3) = t
               track_temp(ifile,i,4) = u0
            else
               red_rot = rand_red_ROTATION( idum )
               if ( t/t_max .lt. 0.5d0 ) then
                  red_rot = red_rot * (1.-2.*t/t_max)
                  v0 = v0 +    red_rot
                  b0 = b0 + 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               else
                  red_rot = red_rot * (2.*t/t_max-1.)
                  v0 = v0 -    red_rot
                  b0 = b0 - 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               end if
            end if
            t = t + deltat
         end do ! i
         !----------------------------------------------------
      end do ! ifile

      print*, ' >>> interpolation pour chaque masse'
      do im= 1, n_mass
         ! Valeur en cours de la masse
         lamasse = masse(im)
         nmasse = -1
         do ifile= 1, nfile
            if ( lamasse .eq. m(ifile) ) then
               nmasse = ifile
            endif
         end do
         ! si "lamasse" appartient  la grille on n'interpole pas
         if ( nmasse .gt. 0 ) then
c            print*, ' === M= ', masse(im), ' pas d''interpol !'
c            pause
            do i= 1, npt_track
               track_interpol(im,i,1) = track_temp(nmasse,i,1) ! B
               track_interpol(im,i,2) = track_temp(nmasse,i,2) ! V
               track_interpol(im,i,3) = track_temp(nmasse,i,3) ! ge
            end do
         else
         ! si "lamasse" N'appartient PAS on interpole
            ! On dt. les valeurs de masse encadrant "lamasse"
            do ifile= 1, nfile
               if ( (m(ifile) .lt. lamasse) .AND.
     &              (lamasse  .lt. m(ifile+1))  ) then
                  indice_m = ifile
               end if
               if ( indice_m .eq. 1 ) then
                  im1 = 1
                  im2 = 2
                  im3 = 3
               end if
               if ( indice_m .eq. nfile-1 ) then
                  im1 = nfile-2
                  im2 = nfile-1
                  im3 = nfile
               end if
               if ( (indice_m .ne. 1) .AND.
     &              (indice_m .ne. nfile-1) ) then
                  im1 = indice_m - 1
                  im2 = indice_m
                  im3 = indice_m + 1
               end if
            end do

c           Interpolation de B,V,ge pour 0. .le. u .le. 1. :
            delta_u= 1./(npt_MS-1)
            u0=0.d0
            do i= 1, npt_MS
               ! Dt. de B,V,ge sur chacun des 3 tracks
               nm= 0
               do j= im1, im3
                  do k= 1, npt_track
                     B(k)   = track_temp(j,k,1)
                     V(k)   = track_temp(j,k,2)
                     age(k) = track_temp(j,k,3)
                     u(k)   = track_temp(j,k,4)
                  end do
                  nm = nm + 1
c                  print*, 'u(k) = ', u(k)
             call interpol_lin(B,   u, npt_track, u0, Bm(nm),   bidon)
             call interpol_lin(V,   u, npt_track, u0, Vm(nm),   bidon)
             call interpol_lin(age, u, npt_track, u0, agem(nm), bidon)
             end do ! j
             ! Interpolation en masse
             massss(1) = m(im1)
             massss(2) = m(im2)
             massss(3) = m(im3)

             call interpol_quad(Bm,  massss, 3, lamasse, b0,   bidon)
             call interpol_quad(Vm,  massss, 3, lamasse, v0,   bidon)
             call interpol_quad(agem,massss, 3, lamasse,  t,   bidon)

             track_interpol(im,i,1) = b0
             track_interpol(im,i,2) = v0
             track_interpol(im,i,3) = t

             u0 = u0 + delta_u
             
             end do ! i
             ! Dt. de la valeur mini. de "u(npt_track)" (pout pouvoir interpoler
             ! sur la POST-MS
             umax_min = track_temp(im1,npt_track,4)
             do j= im1, im3
                u0 = track_temp(j,npt_track,4)
                if ( u0 .lt. umax_min ) then
                   umax_min = u0
                   imini = j
                end if
             end do
             if ( umax_min .lt. 1.d0 ) then
                print*, ' '
                print*, ' >>> Pb. dans "interpol_BV_ROT_quad" :'
                print*, '     umax_mini .lt. 1.d0'
                print*, '     pour M= ', m(imini)
                stop
             end if
             ! Dt. du pas de temps en "u" pour la portion de trajet en dehors
             ! de la Main Sequence :
             delta_u = (umax_min-1.d0)/npt_post
             u0 = 1.d0 + delta_u
             do i= npt_MS+1, npt_MS+npt_post
                ! Dt. de B,V,ge pour chacun des 3 tracks
                nm = 0
                do j= im1, im3
                   do k= 1, npt_track
                      B(k)   = track_temp(j,k,1)
                      V(k)   = track_temp(j,k,2)
                      age(k) = track_temp(j,k,3)
                      u(k)   = track_temp(j,k,4)
                   end do
                   nm = nm + 1
            call interpol_lin(B  , u, npt_track, u0, Bm(nm),   bidon)
            call interpol_lin(V  , u, npt_track, u0, Vm(nm),   bidon)
            call interpol_lin(age, u, npt_track, u0, agem(nm), bidon)
                end do ! j
                ! Interpolation en MASSE
                massss(1) = m(im1)
                massss(2) = m(im2)
                massss(3) = m(im3)
  
             call interpol_quad(Bm,  massss, 3, lamasse, b0,   bidon)
             call interpol_quad(Vm,  massss, 3, lamasse, v0,   bidon)
             call interpol_quad(agem,massss, 3, lamasse,  t,   bidon)

                track_interpol(im,i,1) = b0
                track_interpol(im,i,2) = v0
                track_interpol(im,i,3) = t

                u0 = u0 + delta_u
             end do ! i
         end if ! if ( nmasse .gt. 0 )
      end do ! im

c     =========================================================
c     On dtermine les valeurs tau(i) des dures des MS pour
c     chaque tracks, on en fait la somme tau_TOT
      tau_TOT = 0.d0
      do im= 1, n_mass
         t       = track_interpol(im,1,3) ! ge initial
         t_max   = track_interpol(im,npt_track,3) ! ge max.
         tau_TOT = tau_TOT + t_max - t
         !print*, 'M= ', masse(im)
         !print*, 't       = ', t
         !print*, 't_max   = ', t_max
         !print*, 't_max-t = ',  t_max - t
      end do

c     =========================================================
c     Dtermination de "Delta_t"
      delta_t = tau_TOT/Ntot

c     =========================================================
c     On interpole temporellement chaque trajet volutif cr
c      l'tape prcdente (un track de "npt_track" points).
c     On stocke les rsultats dans un seul fichier qui sera 
c     rutilis ensuite par les routines suivantes.
      print*, ' >>> interpolation temporelle !'
      ! Dtermination du nombre d'enregistrement dans le fichier
      n_rec = 0
      do im= 1, n_mass
         t     = track_interpol(im,1,3) ! ge initial
         t_max = track_interpol(im,npt_track,3) ! ge max.
         do while ( t .lt. t_max )
            n_rec = n_rec + 1
            t = t + delta_t
         end do ! while ( t .lt. t_max )
      end do ! im
      ! Interpolation et criture
      n_rec_2 = 0
      open(3,status='new',access='direct',recl=n_rec,form='formatted',
     +     file=filename_BV_tot(:long(filename_BV_tot)))
      do im= 1, n_mass
         t     = track_interpol(im,1,3) ! ge initial
         t_max = track_interpol(im,npt_track,3) ! ge max.
         do while ( t .lt. t_max )
            do i= 1, npt_track
               B(i)   = track_interpol(im,i,1)
               V(i)   = track_interpol(im,i,2)
               age(i) = track_interpol(im,i,3)
            end do
            call interpol_lin(B, age, npt_track, t, b0, bidon)
            call interpol_lin(V, age, npt_track, t, v0, bidon)
            n_rec_2 = n_rec_2 + 1
            write(3,3000,rec=n_rec_2) b0, v0
 3000       format(1p2d16.6)
            t = t + delta_t
         end do ! while ( t .lt. t_max )
      end do ! im

      close(3)

      print*, ' '
      print*, ' * Fichier : ', filename_BV_tot(:long(filename_BV_tot)),
     &        ' crit !'
      print*, '   On y a crit : ', n_rec, ' couples (B,V)'
      print*, ' '
      print*, ' * Lecture et interpolations termines !'
      print*, ' '

      return

      end
