c----------------------------------------------------------------

      subroutine  interpol_BV_ROT_Xc( filename, Ntot, rot, idum, 
     &                 n_mass, n_rec, ntracks, masse, filename_BV_tot )

c Obj. : On construit par interpolation des diffrents tracks
c        des trajets volutifs pour chaque valeur de masse
c        contenue dans "masse (i)"

c        Interpolation en masse en caractrisant chaque stade volutif
c        par la valeur de Xc (fraction massique centrale en hydrogne).

c Algorithme : cf. cahier XVIII p. 37

c        Chacun de ces trajets est ensuite interpol
c        tout les "Delta t".

c        Utilisation d'une simulation de l'effet de la ROTATION
c        (option "rot"). Cette possibilit reste trs exprimentale
c        et n'a pas vraiment de support physique. 
c
c        Le rsultat est stock dans un seul fichier

c Entres : * filename        : nom du fichier dans lequel sont inscrits
c                               les noms des fichiers B,V,ge
c           * Ntot            : Nombre total d'toiles avant mise en binaire
c                               et filtrage sur les erreurs
c           * rot             : .true. on utilise la rotation, .false. on ne le
c                               fait pas.
c           * idum            : initialisation des tirages au sort
c           * n_mass          : nombre de valeurs de masse
c           * masse           : tableau contenant toutes les valeurs de masse
c           * filename_BV_tot : nom du fichier o on va crire tous les couples
c                               (B,V)

c D. Cordier, mai-octobre 2001.

      implicit none

      include 'synth_POP.para_com.f'

      integer long, ifile, nfile, nl, idum, n_mass, i, ntracks,
     &        im, indice_m, Ntot, n_rec,  n_rec_2, nmasse, ib, ir

      logical ilestla, rot

      real*8 delta_t, m(nl_max), B(nl_max), V(nl_max),  age(nl_max),
     &    Xc(nl_max), u(nl_max), B_b(npt_track), V_b(npt_track),
     &    age_b(npt_track), u_b(npt_track), B_r1(npt_track), 
     &    V_r1(npt_track), age_r1(npt_track), u_r1(npt_track),
     &    B_r(npt_track), V_r(npt_track), age_r(npt_track), 
     &    t, t_max, b0, v0, u0, bidon, red_rot, rand_red_ROTATION, 
     &    masse(1:nsmax), track_temp(nbr_file_max, npt_track,4), deltat, 
     &    lamasse, m1, m2, t_1, t_2, b_1, b_2, v_1, v_2, u_final1, 
     &    u_final2, track_interpol(nsmax,npt_track,3), tau_TOT

      character filename*(nc_max), filename_BV_tot*(nc_max),
     &          file*(nc_max), file_temp*(nc_max)

      dimension file(1:nbr_file_max)

      external long, rand_red_ROTATION

c ... au cas o ...
      if ( idum .lt. 0 ) then
         idum = -1 * idum
      end if

c Nom du fichier dans lequel on va mettre tous les couples
c (B,V) pour le jeu complet de trajets volutifs.
      filename_BV_tot='BV_tot.BV'
      inquire(file=filename_BV_tot(:long(filename_BV_tot)),
     +        exist=ilestla)
      if ( ilestla ) then
c     Au cas accidentel o le fichier 'BV_tot.BV' existe on
c     l'efface !
         open(unit=1,status='unknown',file=
     +     filename_BV_tot(:long(filename_BV_tot)))
         close(1,status='delete')
      end if
c     -----------------------------------------------------
      inquire(file=filename(:long(filename)),exist=ilestla)
      if ( .NOT. ilestla ) then
         print*, 'Le fichier : ', filename(:long(filename))
         print*, 'est absent, on stoppe !'
         stop
      end if
      !>>>>>>>>>>>>>>>>>>>>
      open(unit=1,status='old',form='formatted',file=
     +     filename(:long(filename)))
      nfile=0
      do while ( .true. ) 
        nfile=nfile+1
        read(1,*,end=100) m(nfile)
        read(1,1000,end=100) file(nfile) ! On lit les noms des fichiers (B,V,ge)
                                         !  traiter.
        if ( nfile .gt. nbr_file_max ) then
           print*, 'Il y a trop de fichiers dans ', 
     +              filename(:long(filename))
           print*, 'Il faut augmenter la valeur du paramtre'
           print*, '<<nbr_file_max>> dans <<synth_POP.para_com.f>>'
           print*, 'On stoppe !'
           stop
        end if
 1000   format(A)
      end do

 100  nfile=nfile-1
      close(unit=1)
      !>>>>>>>>>>>>>>>>>>>>
      print*, ' '
      print*, '----------------------------------------------- '
      print*, ' * Il y a ', nfile, ' fichier(s)  traiter'
      print*, ' '
      print*, ' * Voici leurs noms :'
      print*, ' '
      do ifile= 1, nfile
         write(6,1000) file(ifile)
      end do
c      print*, ' '
c      print*, ' * Pas de temps utilis : ', delta_t
c      print*, ' '

      print*, ' * ... on traite ces fichiers ...'
      print*, ' '

c     =========================================================
c     On "reformate" chaque track avec un mme nombre de points
c     (npt_track cf. "synth_POP.para_com.f")
      print*, ' >>> reformatage '
      do ifile= 1, nfile
         file_temp=file(ifile)
         !xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
         inquire(file=file_temp(:long(file_temp)),exist=ilestla)
         if ( .NOT. ilestla ) then
            print*, 'Le fichier : ', file_temp(:long(file_temp))
            print*, 'est absent, on stoppe !'
            stop
         end if
         !xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
         open(unit=2,status='old',form='formatted',file=
     +        file_temp(:long(file_temp))) ! On ouvre un fichier (B,V,ge)
         write(6,1000) file(ifile)
         nl=0
         do while ( .true. ) ! on scanne le fichier jusqu'au bout <<<<<<<<<
            nl=nl+1
            read(2,2000,end=200) B(nl), V(nl), age(nl), Xc(nl)
            u(nl) = Xc(nl)/Xc(1)
c            print*, B(nl), V(nl), age(nl)
 2000       format(1p,4d16.6)
            if ( nl .gt. nl_max ) then
               print*, 'Dans le fichier : ', file_temp(:long(file_temp))
               print*, 'Il y a un nombre de modles suprieur '
               print*, 'nl_max = ', nl_max
               print*, 'il faut changer la valeur de ce paramtre !'
               print*, 'On stoppe !'
               stop
            end if
         end do
 200     close(unit=2)
         nl=nl-1
         t=age(1)
         t_max=age(nl)
         print*, '==> dans ce fichier, nmbre de modles : ', nl
         print*, '    Age_ini = ', t
         print*, '    Age_max = ', t_max

         ! On interpole pour avoir au final "npt_track" points par tracks
         deltat = (t_max-t)/(npt_track-1)
c         print*, 'deltat = ', deltat
         do i= 1, npt_track
c            print*, 'i = ', i
c            print*, 't = ', t
            call interpol_lin(B, age, nl, t, b0, bidon)
            call interpol_lin(V, age, nl, t, v0, bidon)
            call interpol_lin(u, age, nl, t, u0, bidon)
            if ( .NOT. rot ) then
c               write(1,3000) b0, v0
               track_temp(ifile,i,1) = b0
               track_temp(ifile,i,2) = v0
               track_temp(ifile,i,3) = t
               track_temp(ifile,i,4) = u0
            else
               red_rot = rand_red_ROTATION( idum )
               if ( t/t_max .lt. 0.5d0 ) then
                  red_rot = red_rot * (1.-2.*t/t_max)
                  v0 = v0 +    red_rot
                  b0 = b0 + 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               else
                  red_rot = red_rot * (2.*t/t_max-1.)
                  v0 = v0 -    red_rot
                  b0 = b0 - 2.*red_rot
c                  write(1,3000) b0, v0
                  track_temp(ifile,i,1) = b0
                  track_temp(ifile,i,2) = v0
                  track_temp(ifile,i,3) = t
                  track_temp(ifile,i,4) = u0
               end if
            end if
            t = t + deltat
         end do ! i
      end do

c     =========================================================
c     Pour chaque valeur de masse on construit un trajet volutif
c     interpol par rapport  ceux calculer par CESAM

c TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT
      print*, ' >>> interpolation pour chaque masse'
      do im= 1, n_mass
         ! Valeur en cours de la masse
         lamasse = masse(im)
         nmasse = -1
         do ifile= 1, nfile
            if ( lamasse .eq. m(ifile) ) then
               nmasse = ifile
            endif
         end do
         if ( nmasse .gt. 0 ) then
            do i= 1, npt_track
               track_interpol(im,i,1) = track_temp(nmasse,i,1) ! B
               track_interpol(im,i,2) = track_temp(nmasse,i,2) ! V
               track_interpol(im,i,3) = track_temp(nmasse,i,3) ! ge
            end do
         else
            ! On dt. les valeurs de masse encadrant "lamasse"
            do ifile= 1, nfile
               if ( (m(ifile) .lt. lamasse) .AND.
     &              (lamasse  .lt. m(ifile+1))  ) then
                  indice_m = ifile
               end if
            end do
            m1 = m(indice_m)
            m2 = m(indice_m+1)
            print*, 'm1= ', m1, ', m2= ', m2

            ! Dt. du "track de base" et du track rebuilt" 
            u_final1 = track_temp(indice_m,npt_track,4)
            u_final2 = track_temp(indice_m+1,npt_track,4)
            print*, 'u_final1= ',  u_final1, ', u_final2= ', u_final2

            if ( u_final1 .gt. u_final2 ) then
               ib = indice_m
               ir = indice_m + 1
            else
               ib = indice_m + 1
               ir = indice_m
            end if
            ! Interpolation du "track rebuilt"
            do i= 1, npt_track
               B_b(i)   = track_temp(ib,i,1)
               V_b(i)   = track_temp(ib,i,2)
               age_b(i) = track_temp(ib,i,3)
               u_b(i)   = track_temp(ib,i,4)

               B_r1(i)   = track_temp(ir,i,1)
               V_r1(i)   = track_temp(ir,i,2)
               age_r1(i) = track_temp(ir,i,3)
c               print*, 'age_r1(i) = ', age_r1(i)

               u_r1(i)   = track_temp(ir,i,4)
            end do ! i
            ! Interpolation du track "re-built"
            do i= 1, npt_track
               u0 = u_b(i)
c               print*, 'u0 = ', u0
           call interpol_lin(B_r1,  u_r1,npt_track,u0, B_r(i),  bidon)
           call interpol_lin(V_r1,  u_r1,npt_track,u0, V_r(i),  bidon)
           call interpol_lin(age_r1,u_r1,npt_track,u0, age_r(i),bidon)
           print*, 'u_r1(1)= ', u_r1(1), ', u0 = ', u0,
     +             ', u_r1(npt_track) = ', u_r1(npt_track)
           print*, 'age_r1(i) = ', age_r1(i), ', age_r(i)= ', age_r(i)

            end do ! i
            ! Interpolation en MASSE
            m1  = m(ib)
            m2  = m(ir)
            do i= 1, npt_track
               B_1 = B_b(i)
               B_2 = B_r(i)

               V_1 = V_b(i)
               V_2 = V_r(i)

               t_1 = age_b(i)
               t_2 = age_r(i)

               b0 = (B_2-B_1)/(m2-m1)*(lamasse-m1) + B_1
               v0 = (V_2-V_1)/(m2-m1)*(lamasse-m1) + V_1
               t  = (t_2-t_1)/(m2-m1)*(lamasse-m1) + t_1
               print*, 't_1=', t_1, ', t= ', t, ', t_2=', t_2

               track_interpol(im,i,1) = b0
               track_interpol(im,i,2) = v0
               track_interpol(im,i,3) = t
            end do ! i
         end if
      end do ! im
c TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT

c     =========================================================
c     On dtermine les valeurs tau(i) des dures des MS pour
c     chaque tracks, on en fait la somme tau_TOT
      tau_TOT = 0.d0
      do im= 1, n_mass
         t       = track_interpol(im,1,3) ! ge initial
         t_max   = track_interpol(im,npt_track,3) ! ge max.
         tau_TOT = tau_TOT + t_max - t
         print*, 't_max-t = ',  t_max - t
      end do

c     =========================================================
c     Dtermination de "Delta_t"
      delta_t = tau_TOT/Ntot

c TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST 
      open(1,status='unknown',form='formatted',file='TEST.dat')
      do im= 1, n_mass
         do i= 1, npt_track
            write(1,*) track_interpol(im,i,1)-track_interpol(im,i,2),
     &                 track_interpol(im,i,2)+18.9
         end do
      end do
      close(1)
      print*, 'TEST termin !'
      print*, 'Fichier TEST.dat crit !'
      stop
c
c TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST 

c     =========================================================
c     On interpole temporellement chaque trajet volutif cr
c      l'tape prcdente (un track de "npt_track" points).
c     On stocke les rsultats dans un seul fichier qui sera 
c     rutilis ensuite par les routines suivantes.
      print*, ' >>> interpolation temporelle !'
      ! Dtermination du nombre d'enregistrement dans le fichier
      n_rec = 0
      do im= 1, n_mass
         t     = track_interpol(im,1,3) ! ge initial
         t_max = track_interpol(im,npt_track,3) ! ge max.
         do while ( t .lt. t_max )
            n_rec = n_rec + 1
            t = t + delta_t
         end do ! while ( t .lt. t_max )
      end do ! im
      ! Interpolation et criture
      n_rec_2 = 0
      open(3,status='new',access='direct',recl=n_rec,form='formatted',
     +     file=filename_BV_tot(:long(filename_BV_tot)))
      do im= 1, n_mass
         t     = track_interpol(im,1,3) ! ge initial
         t_max = track_interpol(im,npt_track,3) ! ge max.
         do while ( t .lt. t_max )
            do i= 1, npt_track
               B(i)   = track_interpol(im,i,1)
               V(i)   = track_interpol(im,i,2)
               age(i) = track_interpol(im,i,3)
            end do
            call interpol_lin(B, age, npt_track, t, b0, bidon)
            call interpol_lin(V, age, npt_track, t, v0, bidon)
            n_rec_2 = n_rec_2 + 1
            write(3,3000,rec=n_rec_2) b0, v0
 3000       format(1p2d16.6)
            t = t + delta_t
         end do ! while ( t .lt. t_max )
      end do ! im

      close(3)

      print*, ' '
      print*, ' * Fichier : ', filename_BV_tot(:long(filename_BV_tot)),
     &        ' crit !'
      print*, '   On y a crit : ', n_rec, ' couples (B,V)'
      print*, ' '
      print*, ' * Lecture et interpolations termines !'
      print*, ' '

c TEST TEST TEST
c      stop
c TEST TEST TEST

      return

      end
