c**********************************************************************
 
      subroutine int_lin_synthP(f, x, nx, x0, fx0, dfsdx)

c Version amliore de "interpol_lin"

c D. Cordier, novembre 2001.

      implicit none
 
      integer i, nx
 
      real*8 f, x, x0, fx0, dfsdx,
     +       a, b, xi, xi1, yi, yi1
 
      dimension f(nx), x(nx)
 
c Gestion de quelques cas particuliers
      if ( nx .le. 1 ) then
         print*, 'Pb. dans "int_lin_synthP", nx = ', nx, ' !'
         stop
      end if
      if ( nx .eq. 2) then
         go to 300
      end if

c On cherche "l'indice" de x0 :
      call locate(x,nx,x0,i)
      if ( i .eq. 0 ) then
         xi  = x(1)
         xi1 = x(2)
         yi  = f(1)
         yi1 = f(2)
      else
         if ( i .eq. nx ) then
            xi  = x(nx-1)
            xi1 = x(nx)
            yi  = f(nx-1)
            yi1 = f(nx)
         else
            xi  = x(i)
            xi1 = x(i+1)
            yi  = f(i)
            yi1 = f(i+1)
         end if
      end if

      if(xi.eq.xi1) then
        print*,'Division par 0 dans "int_lin_synthP" !'
        print*, 'i = ', i
        print*, 'x(1) = ', x(1), ', f(1) = ', f(1)
        print*, 'x0   = ', x0
        print*, 'x(nx)= ', x(nx), ', f(nx) = ', f(nx)
        print*, 'xi  = ', xi
        print*, 'xi1 = ', xi1
        stop
      endif
 
      a = (yi-yi1)/(xi-xi1)
      b = yi-a*xi
 
      fx0 = a*x0+b
 
      dfsdx = a
 
      return
 
c Cas o nx = 2
 300  if ( x(1) .eq. x(2) ) then
         print*, 'Pb. dans "interpol_lin", nx=2 et x(1)=x(2) !'
         stop
      end if
      a=(f(2)-f(1))/(x(2)-x(1))
      b=f(1)-a*x(1)
 
      fx0=a*x0+b
      dfsdx=a
 
      return
 
      end
 
