c**********************************************************

      function int_Salpeter( M, Mmin, Mmax, N_Mmax )

c Fonction donnant l'intgrale de la fonction de Salpeter
c entre la valeur minimale de masse choisie (Mmin) et
c une certaine valeur de masse M (toutes les masses en
c unit solaire).

c D. Cordier, 16 octobre 2001.

c Entres : * M      : la masse (en u. solaire)
c           * Mmin   : masse (en u. solaire) minimale
c           * Mmax   : masse (en u. solaire) maximale
c           * N_Mmax : nbr d'toiles dsires pour Mmax

      implicit none

      include 'synth_POP.para_com.f'

      real*8 int_Salpeter, M, Mmin, Mmax, N_Mmax, alpha, a

c Initialisation
      alpha = alpha_salpeter
      a = (1.d0-alpha)*Mmax**(alpha-1.d0)*N_Mmax

c Valeur de l'intgrale de la fonction de Salpeter de Mmin  M :
      int_Salpeter = -a*(-M**2*Mmin**alpha+Mmin**2*M**alpha)/
     #M**alpha/(-1.E0+alpha)/(-2.E0+alpha)/Mmin**alpha

      return

      end

