c**************************************************************

      subroutine dichot_SUM( y0, f, a, b, x0)

c Subroutine "dichotomie" des "Numerical Recipies" adapte  la
c situation (arguments de "f").

c D. Cordier, juin, septembre 2001.

c Entres :
c * y0   : valeur pour laquelle on veut avoir f(x0)=y0
c * f    : la fonction en question (dclare en external)
c * a,b  : les bornes de l'intervalle o on cherche la solution

c Sorties :
c * x0   : la solution cherche.
 
      implicit none

      integer niter, nitermax

      real*8 y0, f, x0, diff, a, b, x1, x2, xm, ym, precis

      parameter ( precis = 0.01d0, nitermax = 1000 )

      external f

      x1 = a
      x2 = b
      niter = 0
      diff = 1.d0
      do while ( diff .gt. precis )
         niter = niter + 1
         !print*, ' niter = ',  niter
         if ( niter .gt. nitermax ) then
            print*, 'Pb. dans dichot niter .gt. nitermax'
            stop
         end if
         xm = (x1+x2)/2.
         ym = f(xm,0) ! Modif. ICI D.C.
         diff = abs(y0 - ym)
         if ( ym .gt. y0 ) then
            x2 = xm
         else
            x1 = xm
         end if
      end do

      x0 = xm

      return

      end
