#!/usr/bin/perl
#----------------------------------------------------
#
#       Programme Perl frontal de "synth_POP"
#
#       But : 
#
#----------------------------------------------------
# D. Cordier, octobre 2001.
#
#----------------------------------------------------
# Programme principale :
#
# Executable utilis
$EXE_SYNTHPOP='./CReSyPS';
#
# Rponses aux questions poses par le programme "synth_POP" :
# Nom du fichier contenant les noms des tracks (B,V,ge) :
$LISTNAMEFILE = "liste_BVageFiles.in";
# Valeur du pas de temps :
$DELTA_T = "0.01";
# Utilise-t-on la simulation de la rotation ? 
$ROT = "F";
# Valeur du taux de binarit :
$BIN_RATE = "0.02";
# Valeur du module de distance en B :
$MOD_DIST_B = "18.9";
# Valeur du module de distance en V :
$MOD_DIST_V = "18.9";
# Valeur de Rv :
$Rv = "3.24";
# Erreur max. sur magnitude B :
$ERR_MAX_B = "0.015";
# Erreur max. sur magnitude V :
$ERR_MAX_V = "0.015";
# Galaxie ?
$GALAXIE = "smc";
# Nom du fichier de sortie :
$FILE_OUT = "toto.dat";
# ---------------------------------------------------
# On initialise
&initialisation();

# On excute le programme de synthse de population
&run_synth_POP();

# Petit message de fin de boulot
&TheEnd();

#----------------------------------------------------
sub initialisation() {
# On demande un permier entier d'initialisation et
# le nombre de fois qu'il faut faire tourner le programme
# (pour pouvoir ensuite faire des moyennes et cart-types)
print " ";
print " *************************************\n ";
print " \n";
print "    Programme frontal de CReSyPS\n";
print " \n";
print "  ************************************\n ";
print " \n";
print " - Valeur du premier entier d'initialisation :\n";
print "   (il doit tre ngatif !)\n";
$IDUM = <STDIN>;
#print " $IDUM\n";
if ( $IDUM > 0 ) {
    print " ==============================\n";
    print " CET ENTIER DOIT ETRE NEGATIF !\n";
    print " ==============================\n";
    exit(0);
}
print " \n";
print " - Nombre total d'itrations :\n";
$NTOT = <STDIN>;
#print " $NTOT\n";
}
#-----------------------------------------------------
sub run_synth_POP {
# On rpond aux questions du programme
# D.C., octobre 2001.

open (FSOR, "| $EXE_SYNTHPOP");
printf FSOR ("$LISTNAMEFILE\n");
printf FSOR ("$DELTA_T\n");
printf FSOR ("$ROT\n");
printf FSOR ("$BIN_RATE\n");
printf FSOR ("$IDUM\n");
printf FSOR ("$MOD_DIST_B\n");
printf FSOR ("$MOD_DIST_V\n");
printf FSOR ("$Rv\n");
printf FSOR ("$ERR_MAX_B\n");
printf FSOR ("$ERR_MAX_V\n");
printf FSOR ("$GALAXIE\n");
printf FSOR ("$FILE_OUT\n");
close(FSOR);

}
#-----------------------------------------------------
sub TheEnd {
# On dit que c'est fini !!!
    print " \n";
    print "==================================================\n";
    print " \n";
    print " C'est fini !\n";
    print " \n";
exit(0);
}
































