c----------------------------------------------------------------
c
c                   Programme "CReSyPS.f"
c
c----------------------------------------------------------------

c Goal: buid a synthetic sample of star from three columns (B,V,age) files 
c coming from stellar evolution calculations.

c D. Cordier, Rennes (France), april 2001, january 2004.
c http://astro.ensc-rennes.fr

      implicit none

      include 'synth_POP.para_com.f'

      integer idum, idum_ini, nstar, nobj, nobj_filt, i, n_out, n_mass, 
     &        ntracks, Ntot, n_rec, ch_distri_EBmV

      logical rot, EBmV_cst

      real*8 grd(nsmax,ngmax), grdobj(nsmax,ngmax), 
     &       grdobj_filtered(nsmax,ngmax),grdobj2(nsmax,ngmax), 
     &       grd_out(nsmax,ngmax), depth, mod_B, mod_V, Rv, 
     &       err_max_B, err_max_V, delta_t, beta, red_SMC, red_LMC, 
     &       N_Mmax, masse(1:nsmax), EBmV1, EBmV_moy, Sig_EBmV

      character filename*(nc_max), filename_out*(nc_max),
     &          filename_BV_tot*(nc_max), file_bin*(nc_max),
     &          file_mod*(nc_max), galax*3

      external red_SMC, red_LMC

c Chating ...
      call interac_1( filename, Ntot, rot, beta, mod_B, mod_V,
     & depth, Rv, EBmV_cst, ch_distri_EBmV, EBmV1, EBmV_moy, Sig_EBmV,
     & err_max_B, err_max_V, galax, filename_out, idum )

      idum_ini = idum ! valeur i initiale de idum (enregistre dans un fichier de sortie)
c Cration d'une distribution de masse en suivant une loi de
c Salpeter
      call distri_masse( .true., idum, filename, Ntot, masse, n_mass, 
     &                   ntracks )
      
      if ( abs(idum) .gt. 100000 ) then
         idum = idum/10000
      end if
      if ( abs(idum) .gt. 100000000 ) then
         idum = idum/1000000
      end if
      if ( idum .gt. 0 ) then
         idum = -idum
      end if

c Fabrication d'un seul fichier (B,V) en utilisant tous les
c fichiers (B,V,age) et en interpolant tous les "Delta t"
      call interpol_BV_ROT_quad( filename, Ntot, rot, idum, n_mass,
     &                      n_rec, ntracks, masse, filename_BV_tot )
      
      if ( abs(idum) .gt. 100000 ) then
         idum = idum/10000
      end if
      if ( abs(idum) .gt. 100000000 ) then
         idum = idum/1000000
      end if
      if ( idum .gt. 0 ) then
         idum = -idum
      end if

      print*, 'OK'

c +++++++++++++++++++++++++++++++++++++++++++++++++++
c Creation des couples de binaires dans l'chantillon
      call make_bin(filename_BV_tot, idum, n_rec, beta, file_bin, nobj )
      !print*, 'aprs make_bin idum = ', idum
      !pause
      
      if ( abs(idum) .gt. 100000 ) then
         idum = idum/10000
      end if
      if ( abs(idum) .gt. 100000000 ) then
         idum = idum/1000000
      end if
      if ( idum .gt. 0 ) then
         idum = -idum
      end if

c +++++++++++++++++++++++++++++++++++++++++++++++++++
c Application du module de distance
c      print*, 'grdobj(1,1) = ', grdobj(1,1)
      call add_module( idum, file_bin, galax, file_mod, nobj, 
     &                 mod_B, depth, mod_V )
c      print*, 'grdobj(1,1) = ', grdobj(1,1)
      if ( abs(idum) .gt. 100000 ) then
         idum = idum/10000
      end if
      if ( abs(idum) .gt. 100000000 ) then
         idum = idum/1000000
      end if
      if ( idum .gt. 0 ) then
         idum = -idum
      end if

c +++++++++++++++++++++++++++++++++++++++++++++++++++
c "bruitage" des donnes
      call add_noise_filter(idum, file_mod, nobj, galax, 
     &     err_max_B, err_max_V, grdobj_filtered, nobj_filt )

c +++++++++++++++++++++++++++++++++++++++++++++++++++
c On forme (B-V), on tire au sort et on ajoute E(B-V)
c on dt. et ajoute l'absorption Rv.
      if ( galax .EQ. 'smc' ) then
         call BmV_red_abs(idum, grdobj_filtered, nobj_filt, Rv,
     &                    EBmV_cst, ch_distri_EBmV, EBmV1, EBmV_moy, 
     &                    Sig_EBmV, red_SMC, grdobj2 )
      else
         if ( galax .EQ. 'lmc' ) then
         call BmV_red_abs(idum, grdobj_filtered, nobj_filt, Rv, 
     &                    EBmV_cst, ch_distri_EBmV, EBmV1, EBmV_moy, 
     &                    Sig_EBmV, red_LMC, grdobj2 )
         else
            print*, 'Problme : de quelle galaxie s''agit-il ?'
            stop
         end if
      end if

      if ( abs(idum) .gt. 100000 ) then
         idum = idum/10000
      end if
      if ( abs(idum) .gt. 100000000 ) then
         idum = idum/1000000
      end if
      if ( idum .gt. 0 ) then
         idum = -idum
      end if

c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c Ecriture des fichiers de sortie :
c
c       (1) fichier contenant les valeurs des diffrents paramtres
c       (2) le fichier contenant les ((B-V), V)

      call record_output( idum_ini, filename, Ntot, rot, beta, 
     &  mod_B, mod_V, depth, Rv, EBmV_cst, EBmV1, EBmV_moy, Sig_EBmV,
     &  err_max_B, err_max_V, galax, grdobj2, nobj_filt, filename_out )

      end

c--------------------------------------------------------------------

      subroutine  interac_1( filename, Ntot, rot, beta, mod_B, mod_V,
     & depth, Rv, EBmV_cst, ch_distri_EBmV, EBmV1, EBmV_moy, Sig_EBmV,
     & err_max_B, err_max_V, galax, filename_out, idum )

c Lecture des diffrents paramtres  prendre en compte pour 
c calculer la population stellaire synthtique.

c Mai 2001, revisit en septembre 2001, idem novembre-dcembre 2001.

c D. Cordier

      implicit none

      include 'synth_POP.para_com.f'

      integer idum, Ntot, ch_distri_EBmV

      logical rot, EBmV_cst

      real*8 mod_B, mod_V, depth, Rv, err_max_B, err_max_V, beta, EBmV1,
     &       EBmV_moy, Sig_EBmV

      character filename*(nc_max), filename_out*(nc_max), galax*3

      print*, ' '
      print*, '**************************************'
      print*, ' '
      print*, '          This is CReSyPS'
      print*, ' '
      print*, '**************************************'
      print*, ' '

 10   print*, ' - Name of the file where  (Mass,B,V,age,Xc) data are stored:
     +'
      print*, '   (e.g. ''liste_BVageXc_Files.in'')'
      read(5,'(A)',err=10) filename

 11   print*, ' '
      print*, ' - Stars number before binarity and filtering :'
      print*, '   (Computational time for 20 000 stars: approx.  8 min)'
      print*, '   (Computational time for 40 000 : approx. 39 min)'
      read(5,*,err=11) Ntot
      if ( Ntot .lt. 0.d0 ) then
         go to 11
      end if
      if ( Ntot .gt. 1.d5 ) then
         print*, ' >>>> Not toot large?'
         pause
      end if

 7    print*, ' '
      print*, ' - Salpeter''s law exponant:'
      print*, '   (ex.: 2.35 )'
      read(5,*,err=7) alpha_salpeter
      if ( (alpha_salpeter .le. 1.d0) .OR. 
     &     (alpha_salpeter .gt. 3.d0) ) then
         print*, 'Are you sure?'
         go to 7
      end if

 9    print*, ' '
      print*, ' - Do we simulate the photometric effect of rotation? :'
      print*, '   (T/F)'
      read(5,*,err=9) rot

 12   print*, ' '
      print*, ' - Binarity rate:'
      print*, '   (e.g.: 0.1 )'
      read(5,*,err=12) beta
      if ( (beta .lt. 0.) .OR. (beta .gt. 1.) ) then
         print*, 'Be careful!'
         print*, '0. <= beta <= 1. !'
         go to 12
      end if

      print*, ' '
 20   print*, ' - Please, give me a negative integer (random function in
     &it):'
      print*, '   (e.g. -72361)'

      print*, ' '
      read(5,*,err=20) idum

      if ( idum .gt. 0 ) then
         print*, 'BECAREFUL ===>>> this number has to be NEGATIVE!'
         go to 20
      end if

      print*, ' '
 31   print*, ' - Distance modulus in V :'
      print*, '   (e.g. 19.)'
      read(5,*,err=31)  mod_V
      if ( mod_V .lt. 17.d0 ) then
         print*, ' ATTENTION  cette valeur de module !'
         print*, ' pour que les fonctions de distribution d''cart-type'
         print*, ' puissent tre utilises il faut que les magn. tombent
     +'
         print*, ' dans le domaine o elles sont dfinies'
         pause
      end if

      print*, ' '
 32   print*, ' -  Depth of the Cloud (SMC or LMC) in mag:'
      print*, '    (ex.: 0.1 )'
      read(5,*,err=31)  depth
      if ( (depth .gt. 1.d0) .OR.  (depth .lt. 0.d0) ) then
         print*, ' BECAREFUL!'
         go to 32
      end if

      print*, ' '
 50   print*, ' - Rv:'
      print*, '   (e.g. Rv = 3.24 pour Schlegel et al. (1998)' 
      read(5,*,err=50)  Rv
      if ( Rv .lt. 0. ) then
         print*, ' !!! Rv < 0. !!!'
         go to 50
      end if

      print*, ' '
 61   print*, ' - E(B-V) constant? (T/F) :'
      read(5,*,err=61) EBmV_cst
      if ( EBmV_cst ) then
 60      print*, ' - E(B-V):'
         print*, '   (e.g. 0.10)'
         read(5,*,err=60) EBmV1
      else
         print*, ' - E(B-V) distribution:'
         print*, ' '
         print*, '    + gaussian (1).'
         print*, '    + distribution from OGLE 2 observational values 
     &(2)'
         read(5,*,err=60) ch_distri_EBmV
         if ( (ch_distri_EBmV .ne. 1) .AND. (ch_distri_EBmV .ne. 2) ) 
     &goto 60
         if ( ch_distri_EBmV .eq. 1 ) then
            print*, '   * Mean value of  E(B-V) :'
            read(5,*,err=60) EBmV_moy
            print*, '   * RMS of  E(B-V) :'
            read(5,*,err=60) Sig_EBmV
         end if
      end if

      print*, ' '
 70   print*, ' - Error max. on magnitude B :'
      print*, '   (e.g. 0.015 )'
      read(5,*,err=70) err_max_B
      if ( err_max_B .lt. 0. ) then
         print*, ' !!! Error err_max_B < 0. !!!'
         go to 70
      end if

      print*, ' '
 80   print*, ' - Erreur max. sur magnitude V :'
      print*, '   (e.g. 0.015 )'
      read(5,*,err=80) err_max_V
      if ( err_max_V .lt. 0. ) then
         print*, ' !!! Erreur err_max_V < 0. !!!'
         go to 80
      end if

      print*, ' '
 90   print*, ' - Galaxy? (<<smc>> or <<lmc>>) :'
      read(5,'(A)',err=90) galax
      if ( (galax .NE. 'smc') .AND. (galax .NE. 'lmc')) then
         print*, 'Allowed answers: ''smc'' ou ''lmc'''
         go to 90
      end if

      print*, ' '
 100   print*, ' - Output file name:'
      read(5,*,err=100) filename_out

      return

      end

c----------------------------------------------------------------

      subroutine  distri_masse( lin, idum, filename, Ntot, 
     +                          masse, n_mass, ntracks )

c Cration d'une distribution de masse suivant une loi de Salpeter.

c Pour la description de l'algorithme utilis pour avoir une distribution
c de masse sans "trou" : cf. cahier XVIII p. 20.

C D. Cordier, octobre 2001.

c Entres/sorties :
c
c           * lin      : - .true.  on emploit une loi linaire de Salpeter
c                        - .false. on utilise un tirage au sort
c                      Rq.: .true. garantit une rpartition uniforme des
c                           valeurs de masses (il n'y a plus de "trous"
c                           dans cette distribution.
c
c           * idum     : initialisation tirages au sort
c           * filename : fichier o se trouve les noms des tracks et
c                        les valeurs des masses correspondantes
c           * Ntot     : nbr d'toiles avant mise en binaire et filtrage
c           * masse    : tableau des diffrentes valeurs de masse
c           * n_mass   : nbr de valeurs de la masse
c           * ntracks  : nbr de tracks

c Ecriture d'un fichier de sortie avec l'histogramme des valeurs de masse
c gnres par ce sous-programme.

      implicit none

      include 'synth_POP.para_com.f'

      integer idum, n_mass1, n_mass, i, j, long, ntracks, Ntot,
     &        nm, Nmbin(1:N_bin_mass)

      logical lin, ilestla

      real*8 N_Mmax, Mmin, Mmax, masse, salpeter, mass, inter_mass,
     &       lim_bin_mass, x, Mmax_moy, a, coeffm

      real ran2

      dimension masse(1:nsmax), mass(1:nbr_file_max), 
     &          lim_bin_mass(1:N_bin_mass+1), nm(1:N_bin_mass)

      character filename*(nc_max), name*(nc_max)

      external salpeter, ran2, long

c Au cas o ...
      inquire(file=filename(:long(filename)),exist=ilestla)
      if ( .NOT. ilestla ) then
         print*, 'Le fichier : ', filename(:long(filename))
         print*, 'est absent, on stoppe !'
         stop
      end if

c Dtermination de la valeur de n_mass et de N_max:
      n_mass = Ntot / NtotSNmass
      n_mass1 = n_mass
      if ( n_mass1 .gt. nsmax ) then
         print*, 'Pb. dans "distri_masse" !'
         print*, 'n_mass1 .gt. nsmax !'
         stop
      end if

      N_Mmax = 1.d0

c      pause

c Lecture des valeurs de masse dans le fichier d'entre
      open(1,status='old',form='formatted',
     &     file=filename(:long(filename)))
       i=0
       do while ( .true. )
          i=i+1
          read(1,*,err=100,end=200) mass(i)
          print*, mass(i)
          if ( i .gt. nbr_file_max ) then
             print*, 'Attention : trop grand nombre de fichiers dans'
             print*, filename(:long(filename))
             print*, 'il faut augmenter la valeur de nbr_file_max'
             stop
          end if
          read(1,*,err=100) name
          print*, name
       end do

c Dtermination des valeurs de Mmin et Mmax
 200  close(1)
      ntracks= i-1              ! Nombre effectif de trajets volutifs
      Mmin = mass(1)
      Mmax = mass(1)
      do i= 1, ntracks
         if ( mass(i) .lt. Mmin ) then
            Mmin = mass(i)
         end if
         if ( mass(i) .gt. Mmax ) then
            Mmax = mass(i)
         end if
      end do

c Dtermination des valeurs des masses (au sort ou loi linaire
c suivant l'option choisie)
c      print*, 'Mmin = ', Mmin
c      print*, 'Mmax = ', Mmax
      if ( .NOT. lin ) then
         do i= 1, n_mass
            masse(i) = salpeter( idum, Mmin, Mmax, N_Mmax )
c         print*, 'masse(i) = ', masse(i)
         end do
      else
         ! Pour l'algorithme utilis dans cette partie cf. cahier XVIII p. 20
         ! Dcoupage de l'intervalle [Mmax,Mmin] :
         inter_mass= (Mmax-Mmin)/N_bin_mass
         lim_bin_mass(1) = Mmin
         do j= 2, N_bin_mass+1
            lim_bin_mass(j) = lim_bin_mass(j-1) + inter_mass
         end do
         ! Dt. de la constante "a"
         coeffm = 1.d0
 1       Mmax_moy = ( lim_bin_mass(N_bin_mass+1) +
     &                lim_bin_mass(N_bin_mass) ) / 2.
         a = (1.-alpha_salpeter)*coeffm/Mmax_moy**(1.-alpha_salpeter)
         ! Dans chauqe bin on dt. le nombre "Nmbin" de valeurs  tirer
         ! au sort
         do j= 1, N_bin_mass
            Mmax_moy = ( lim_bin_mass(j) + lim_bin_mass(j+1) )/2.
            Nmbin(j) = int(a/(1.-alpha_salpeter)*
     &                     Mmax_moy**(1.-alpha_salpeter))
         end do
         ! Dtermination des valeurs de masses
         n_mass = 0
         do j= 1, N_bin_mass
            do i= 1, Nmbin(j)
               n_mass = n_mass + 1
               if ( n_mass .gt. nsmax ) then
                  print*, 'Pb. 2 dans "distri_masse" !'
                  print*, 'n_mass .gt. nsmax !'
                  stop
               end if
               masse(n_mass) = lim_bin_mass(j) + (lim_bin_mass(j+1)-
     &               lim_bin_mass(j)) * ran2( idum )
            end do
         end do
         if ( n_mass .lt. n_mass1 ) then
            coeffm = coeffm + 1.d0
            go to 1
         end if
      end if

c On fabrique l'hitogramme des masses :
      inter_mass= (Mmax-Mmin)/N_bin_mass
      lim_bin_mass(1) = Mmin
      do j= 2, N_bin_mass+1
         lim_bin_mass(j) = lim_bin_mass(j-1) + inter_mass
      end do
      do j= 1, N_bin_mass
         nm(j) = 0
      end do
      do i= 1, n_mass
         do j= 1, N_bin_mass
            if ( (lim_bin_mass(j) .le. masse(i)) .AND.
     &           (masse(i) .lt. lim_bin_mass(j+1)) ) then
               nm(j) = nm(j) + 1
            end if
         end do
      end do

c Affichage :
      print*, ' '
      print*, ' * On a gnr ', n_mass, ' valeurs de masse'
      if ( lin ) then
         print*, ' * Option "lineaire" (lin=.true.) active !'
      end if
      print*, ' '
c      pause

c Ecriture du fichier de sortie avec les dones relatives  l'histogramme
      print*, ' '
      print*, ' * Ecriture du fichier de sortie pour tracer l''histogram
     &me des valeurs de masse :'
      print*, file_histo(:long(file_histo))
c      pause
      open(13,status='unknown',form='formatted',
     &     file=file_histo(:long(file_histo)))
      do j= 1, N_bin_mass
         x = nm(j)
         write(13,1000) lim_bin_mass(j), x
         write(13,1000) lim_bin_mass(j+1), x
 1000    format(1p2d16.6)
      end do
      close(13)

      return

c Gestion des erreurs
 100  print*, 'Erreur dans la lecture de : ', filename(:long(filename))
      print*, 'vers la ligne : ', 2*i-1
      stop

      end

c----------------------------------------------------------------

      subroutine  make_bin( filename_BV, idum, nstar, beta, file_bin,
     &                      nobj )

c Fabrication des couples de binaires

c Enres/Sorties :

c nstar          : le nombre d'toiles en entre (issues de "interol_BV_TOT")
c nobj           : nombre total d'objet aprs "mise en binaire"

c On utilise trois fichiers temporaires :
c    (1) filename : fichier lequel les donnes B,V ont t enregistres
c                   aprs "interpol_BV_ROT"
c    (2) file_bin : fichier o on crit les rsultats aprs "mise en binaire"
c    (3) file_oqp : fichier stockant la variable logique 'oqp' indiquant si
c                   un objet a dj t utilis dans l'algorithme ou non.
 
      implicit none

      include 'synth_POP.para_com.f'

      integer idum, nstar, nobj, i, i_compagnon, long, lim_nstar

      parameter ( lim_nstar = 4 ) ! Ce paramtre sert  viter de redoutables
                                  ! effets de bords en fin de parcours de la liste
                                  ! des objets qui envoient le code dans une boucle 
                                  ! infinie.
      logical oqp, okupai, finish

      real ran2

      real*4 progress_ratio
	
      real*8 B, V, tirage, alpha_B, alpha_V, magnB_i, magnV_i, 
     &       magnB_comp, magnV_comp, magn_B_binaire, magn_V_binaire, 
     &       beta, taux_bin

      character filename_BV*(nc_max), file_bin*(nc_max), 
     &          file_oqp*(nc_max)

      external ran2, long

c 
c      print*, 'nstar = ', nstar

c Scurit
      if ( nstar .le. lim_nstar ) then
         print*, ' '
         print*, ' >>> Pb. dans "make_bin" : lim_nstar= ', lim_nstar
         print*, ' '
         stop
      end if
c Initialisations
      file_bin= 'fich_inter_bin.dat'
      file_oqp= 'fich_oqp.dat'

      open(1,status='old',access='direct',recl=nstar, form='formatted',
     +     file=filename_BV(:long(filename_BV))) ! Fichier avec donnes B,V avant binaire

      oqp = .false.
      open(2,status='unknown',access='direct',recl=nstar,
     +     file=file_oqp(:long(file_oqp)))
      do i= 1, nstar
         write(2,rec=i) oqp
      end do

      open(3,status='unknown',
     &     form='formatted', file=file_bin(:long(file_bin)))

      nobj=0

      taux_bin = beta/(beta+1.) !cf. cahier XVII p. 31

      print*, ' '
      print*, ' * on fabrique les binaires ...'
      print*, '   (nstar= ', nstar, ' )'
      print*, '   avec beta = ', beta
      print*, ' '
c      print*, 'dans make_bin idum = ', idum
c      pause
c Fabrication des binaires par tirage au sort
      write(6,1)
 1    format('    0%..10%..20%..30%..40%..50%..60%..70%..80%..90%.100%')
      do i= 1, nstar
         tirage=ran2(idum)
c          print*, 'i= ', i
         progress_ratio = nint(nstar/50.)
         if(mod(i,progress_ratio).eq.0.) write(6,'(a,$)')'#'
c         print*, 'dans make_bin idum = ', idum
         ! Pour viter un terrible effet de bord ;-) :
         read(2,rec=i) oqp
c         print*, ' oqp = ', oqp
c        Destin  viter de redoutables effets de bord
c        qui envoient le code dans une boucle infinie !
         if ( i .ge. nstar-lim_nstar ) then
            finish=.true.
         else
            finish=.false.
         end if
         ! 
         if ( (tirage .le. taux_bin) .AND. .NOT. finish ) then ! C'est une binaire
            read(2,rec=i) oqp
c            print*, 'oqp = ', oqp
            if ( .NOT. oqp )  then ! Si pas dj utilise
               okupai = .true.
               do while ( okupai ) 
                  i_compagnon = i + 1 + int((nstar-i)*ran2(idum))
                  if ( i_compagnon .gt. nstar ) then
                        i_compagnon = nstar
                  end if
                  read(2,rec=i_compagnon) oqp
                  if ( .NOT. oqp ) then
                     okupai=.false.
                     oqp = .true.
                     write(2,rec=i_compagnon) oqp 
                  end if
               end do
c              Calcul de la magnitude de la binaire
c               magnB_i = grdstar(i,1)
c               magnV_i = grdstar(i,2)
c               magnB_comp = grdstar(i_compagnon,1)
c               magnV_comp = grdstar(i_compagnon,2)
               read(1,1000,rec=i) magnB_i, magnV_i
 1000          format(1p2d16.6)
               read(1,1000,rec=i_compagnon) magnB_comp, magnV_comp

               alpha_B = 10.**(-(magnB_i-magnB_comp)/2.5d0)
               alpha_V = 10.**(-(magnV_i-magnV_comp)/2.5d0)

               magn_B_binaire = magnB_comp -2.5*log10(1.+alpha_B)
               magn_V_binaire = magnV_comp -2.5*log10(1.+alpha_V)

               nobj=nobj+1
c               grdobj(nobj,1) = magn_B_binaire
c               grdobj(nobj,2) = magn_V_binaire
               write(3,1000) magn_B_binaire, magn_V_binaire

               oqp = .true.
               write(2,rec=i) oqp 
               oqp = .true.
               write(2,rec=i_compagnon) oqp
            end if
         else ! toile simple
            read(2,rec=i) oqp
            if ( .NOT. oqp )  then ! Si pas dj utilise
            nobj=nobj+1
c            grdobj(nobj,1)=grdstar(i,1)
c            grdobj(nobj,2)=grdstar(i,2)
            read(1,1000,rec=i) magnB_i, magnV_i
            write(3,1000) magnB_i, magnV_i

            write(2,rec=i) oqp
            end if
         end if

      end do

      print*, ' '
      print*, ' * Dans le fichier de sortie de "make_bin" il y a : ', 
     &        nobj, ' objets'
c      pause

      close(1,status='delete')
      close(2,status='delete')
      close(3)

      print*, ' '
      print*, ' * Aprs formation des binaires on a ', nobj, ' objets'
      print*, ' '

      return

      end

c----------------------------------------------------------------

      subroutine  add_module( idum, file_bin, galax, file_mod, nobj, 
     &                        mod_B, depth, mod_V )

c Addition du module de distance, dans le cas du SMC on tient compte
c de la profondeur du Nuage.

C D. Cordier, 28 septembre 2001.

      implicit none

      include 'synth_POP.para_com.f'

      integer idum, nobj, i, long

      real*8 B, V, depth, mod_B, mod_V, gasdev_2

      character file_bin*(nc_max), file_mod*(nc_max), galax*3

      external long, gasdev_2

c     Initialisation
      file_mod='file_mod.dat'
      mod_B = mod_V

c     Un peu de causerie ...
      print*, ' '
      print*, ' * On ajoute le module de distance mod_B= ', mod_B
      print*, '   On ajoute le module de distance mod_V= ', mod_V
      print*, '   (on a : ', nobj, ' objets)'
      print*, ' '
c      pause

c     Ouverture des fichiers
      open(1, status='old', form='formatted',
     &     file=file_bin(:long(file_bin)))
      open(2, status='unknown', form='formatted',
     &     file=file_mod(:long(file_mod)))

c     On passe  l'action :
      do i= 1, nobj
         read(1,1000) B, V
 1000    format(1p2d16.6)
c         print*, 'B, V = ', B, V
         if ( galax .eq. 'lmc' ) then ! Cas du LMC : pas de profondeur
            B = B + mod_B       ! B, absorption nglige car inutile dans tape
            V = V + mod_V       !(V) suivante
         else ! Cas du SMC : profondeur du Nuage.
            B = B + mod_B + depth * gasdev_2(idum)
            V = V + mod_V + depth * gasdev_2(idum)
         end if
         write(2,1000) B, V
      end do

      close(1,status='delete')
      close(2)

      return

      end

c----------------------------------------------------------------

      subroutine  add_noise_filter(idum, file_mod, nobj, galax, 
     +         err_max_B, err_max_V, grdobj_filtered, nobj_filt )

c Ajoute un bruit et filtre les donnes, procde en deux
c tapes :
c         (1) tirage au sort d'une valeur de Sig_B et de Sig_V
c         (2) on limine toutes les objets avec : 
c             Sig_B > Sig_B_max et
c             Sig_V > Sig_V_max
c         (3)  l'aide des valeurs de Sig on ajoute un bruit
c             gaussien sur les magnitudes B et V

c D. Cordier, 28 septembre 2001

      implicit none

      include 'synth_POP.para_com.f'

      integer nobj, nobj_filt, idum, i, long

      real*8 sigma(nsmax,ngmax), sigma_filt(nsmax,ngmax), 
     &       grdobj_filtered(nsmax,ngmax), err_max_B, err_max_V, 
     &       SigB, SigV, B, V

      real*8 gasdev_2

      character file_mod*(nc_max), file_noise*(nc_max), 
     &          file_temp*(nc_max), file_sig*(nc_max),
     &          galax*3

      external gasdev_2, long

c Causerie ...
      print*, ' '
      print*, ' * On tire au sort les valeurs des SigB et SigV'
      print*, '   On filtre ensuite les donnes avec :'
      print*, '   - err_max_B = ', err_max_B
      print*, '   - err_max_V = ', err_max_V
      print*, '   On ajoute un bruit gaussien sur B et V'
      print*, ' '
      print*, ' * Nombre d''objets  traiter : ', nobj
      print*, ' '
c      pause

c Ouverture des fichiers
      file_sig='file_sig.dat'
      file_noise='file_noise.dat'
      file_temp='file_temp.dat'

      open(1,status='old',form='formatted', 
     &     file=file_mod(:long(file_mod)))

      open(2,status='unknown',form='formatted', 
     &     file=file_sig(:long(file_sig)))

      open(3,status='unknown',form='formatted', 
     &     file=file_noise(:long(file_noise)))

      open(4,status='unknown',form='formatted', 
     &     file=file_temp(:long(file_temp)))

c $$$$$$$$$ (1) Tirage au sort des Sig_B et Sig_V
      do i= 1, nobj
c         B = grdobj(i,1)
c         V = grdobj(i,2)
         read(1,2000) B, V
         if ( galax .eq. 'smc' ) then
            call rand_Sig_B_SMC( B, SigB, idum )
c            sigma(i,1) = SigB
            write(2,1000) SigB
 1000       format(1pd16.6)
            call rand_Sig_V_SMC( V, SigV, idum )
c            sigma(i,2) = SigV
            write(2,1000) SigV
         end if
         if ( galax .eq. 'lmc' ) then
            call rand_Sig_B_LMC( B, SigB, idum )
c            sigma(i,1) = SigB
            write(2,1000) SigB
            call rand_Sig_V_LMC( V, SigV, idum )
c            sigma(i,2) = SigV
            write(2,1000) SigV
         end if
      end do

c $$$$$$$$$ (2) Filtrage des donnes avec les meilleurs Sig
      nobj_filt = 0 ! nobj_filt est le nombre d'objets restants
                    ! aprs le filtrage.
      rewind(1)
      rewind(2)

      do i= 1, nobj
         read(2,1000) SigB
         read(2,1000) SigV
         read(1,2000) B, V
 2000    format(1p2d16.6)
         if ( (SigB .lt. err_max_B) .AND.
     +        (SigV .lt. err_max_V) ) then
            nobj_filt = nobj_filt + 1
c            grdobj_filtered(nobj_filt,1)=grdobj(i,1) ! Magnitude B
c            sigma_filt(nobj_filt,1) = sigma(i,1) ! Sigma_B
            write(4,3000) B, V, SigB, SigV
 3000       format(1p4d16.6)
c            grdobj_filtered(nobj_filt,2)=grdobj(i,2) ! Magnitude V
c            sigma_filt(nobj_filt,2) = sigma(i,2) ! Sigma_V
         end if
      end do

c $$$$$$$$$ (3) On ajoute un bruit gaussien
      rewind(4)
      do i= 1, nobj_filt ! on ne traite que les objets restants aprs filtrage
         read(4,3000) B, V, SigB, SigV
         !------------------------
c         B = grdobj_filtered(i,1)
c         SigB = sigma_filt(i,1)
         !------------------------
c         V = grdobj_filtered(i,2)
c         SigV = sigma_filt(i,2)
         !------------------------
         grdobj_filtered(i,1) = B + SigB * gasdev_2(idum)
         grdobj_filtered(i,2) = V + SigV * gasdev_2(idum)
        !--------------------------------------------------
      end do


      close(1,status='delete')
      close(2,status='delete')
      close(3,status='delete')
      close(4,status='delete')

      print*, ' '
      print*, ' * filtrage termin, on a maintenant : ', nobj_filt, 
     &' objets'
      print*, ' '
c      pause

      return

      end

c-------------------------------------------------------------------------------------

      subroutine  BmV_red_abs( idum, grd1, nobj, Rv, EBmV_cst, 
     &         ch_distri_EBmV, EBmV1, EBmV_moy, Sig_EBmV, red_nuage, 
     &         grd2 )

c Subroutine ralisant : (1) la formation de (B-V)
c                        (2) la dtermination de E(B-V) pour chaque objet (tirage
c                            au sort suivant la distribution de proba. dtermine
c                             partir des donnes des cphides OGLE 2
c                        (3) on applique le rougissement  (B-V)
c                        (4) on applique l'absorption interstellaire  V

c D. Cordier, 1er octobre 2001, rvision en dcembre 2001.

c Entres : * idum     : entier d'initialisation des tirages au sort
c           * grd1     : grandeurs en entres (magnitudes)
c           * nobj     : nombre d'objetc
c           * Rv       : absorption
c           * EBmV_cst : variable logique, .TRUE.  : on utilise un rougissement
c                                                    constant
c                                          .FALSE. : on utilise la distribution
c                                                    de rougissement des cepheides
c                                                    OGLE (DECONSEILLE au moins pour
c                                                    le SMC)
c           * EBmV1     : valeur du rougissement lorsque celui-ci est choisi cst
c           * ch_distri_EBmV : choix de la distribution de rougissement :
c                              =1 : distribution gaussienne
c                              =2 : distribution tire des donnes OGLE 2
c           * red_nuage : distribution de rougissement (EBmV_cst=.FALSE.), c'est une
c                         fonction.

c Sorties : * grd2      : les grandeurs en sorites (couleur+reddening) et magnitude

      implicit none

      include 'synth_POP.para_com.f'

      integer idum, nobj, i, ch_distri_EBmV

      logical EBmV_cst

      real*8 B, V, Rv, grd1(nsmax,ngmax), grd2(nsmax,ngmax), EBmV, Av,
     &       EBmV1, EBmV_moy, Sig_EBmV, reddening_gauss

c     red_nuage : fonction tirant au hasard une valeur pour
c                 il y a le choix entre "red_SMC" et "red_LMC".
c     le rougissement d'un des nuages.
      real*8 red_nuage
      external red_nuage

      if ( abs(idum) .gt. 10000 ) then
         idum = idum / 1000
      end if
      if ( abs(idum) .gt. 1000000 ) then
         idum = idum / 100000
      end if
      if ( idum .gt. 0 ) then
         idum= -1*idum
      end if

c Un peu de causerie ...
      print*, ' '
      print*, ' * On forme (B-V)'
      print*, '   On ajoute le rougissment tir au sort'
      print*, '   On ajoute l''absorption  la magnitude V'
      print*, ' * Il y a : ', nobj, ' objets  traiter'
      print*, ' '
c      pause

c Formation de (B-V)
      do i= 1, nobj
         grd2(i,1) = grd1(i,1)-grd1(i,2) ! (B-V)
         grd2(i,2) = grd1(i,2)           ! V
      end do
c POur chaque objet un rougissement est tir au sort
      do i= 1, nobj
         !print*, 'idum = ', idum
         !pause

         if ( .NOT. EBmV_cst ) then
            if ( ch_distri_EBmV .eq. 1 ) then
               EBmV = reddening_gauss( idum, EBmV_moy, Sig_EBmV )
            end if
            if ( ch_distri_EBmV .eq. 2 ) then
               EBmV = red_nuage( idum )
            end if
         else
            EBmV = EBmV1
         end if

         Av   = Rv * EBmV

         grd2(i,1) = grd2(i,1) + EBmV
         grd2(i,2) = grd2(i,2) + Av
      end do

      return

      end

c*******************************************************************

      subroutine record_output(idum_ini,filename, Ntot, rot, beta, 
     & mod_B, mod_V, depth, Rv, EBmV_cst, EBmV1, EBmV_moy, Sig_EBmV,
     & err_max_B, err_max_V, galax, grdobj, nobj, filename_out )

c Ecriture des sorties.

c D. Cordier, 2 octobre 2001.

c Entres : - filename     : Nom du fichier contenant les noms des fichiers
c                            de type (B,V,ge) utiliss.
c           - delta_t      : pas de temps utilis
c           - rot          : s'il y a ou pas modlisation de la rotation
c           - beta         : taux de binarit utilis
c           - mod_B        : module de distance en B
c           - mod_V        : idem en V
c           - Rv           : absorption en V
c           - err_max_B    : erreur max. sur la magn. B (utilise lors du filtrage)
c           - err_max_V    : erreur max. sur la magn. V (utilise lors du filtrage)
c           - galax        : indicatif de la galaxie simule ("smc" ou "lmc")

c           - grdobj       : tableau 2 colonnes contenant les couples (B-V), V des
c                            objets.
c           - nobj         : nombre d'objets en sortie.

c           - filename_out : nom du fichier ASCII dans lequel on crit les couples
c                            (B-V), V

c Un fichier "filename_out.log" avec les paramtres utiliss est crit en plus
c de "filename_out".

      implicit none

      include 'synth_POP.para_com.f'

      integer Ntot, nobj, i, long, idum_ini

      logical rot, EBmV_cst

      real*8 grdobj(nsmax,ngmax)

      real*8  beta, mod_B, mod_V, depth, Rv, err_max_B, err_max_V

      real*8 EBmV, EBmV1, EBmV_moy, Sig_EBmV

      character filename*(nc_max), filename_out*(nc_max), galax*3

      external long

c Ecriture du fichier de sortie avec les paramtres
      open(1,status='unknown',form='formatted',
     +     file=filename_out(:long(filename_out))//'.log')
        print*, ' '
        print*, ' * Ecriture du fichier de paramtres : ', 
     +          filename_out(:long(filename_out))//'.log'
        write(1,11) ' **************************************************
     +************'
        write(1,11) ' '//filename_out(:long(filename_out))
        write(1,11) ' **************************************************
     +************'
 11     format(A)
        write(1,1000) ' | Fichier contenant les noms des tracks : ',
     +                filename
        write(1,12) ' | Influence de la rotation : ', rot
 12     format(A30,L4)
 1000   format(A43,A)
        write(1,2001) ' | Idum initial     : ', idum_ini
        write(1,2001) ' | Ntot             : ', Ntot
 2001   format(A22,I10)
        write(1,2000) ' | Taux de binarit : ', beta
 2000   format(A22,F9.2)
        write(1,3000) ' | Module en B      : ', mod_B
        write(1,3000) ' | Module en V      : ', mod_V
        write(1,3000) ' | Prof. SMC        : ', depth
 3000   format(A22,F9.2)
        write(1,300)  ' | Rougissement cst : ', EBmV_cst
 300    format(A22,L2)
        if ( EBmV_cst ) then
         write(1,301)  ' | Valeur de E(B-V) : ', EBmV1
 301     format(A22,F6.3)
        else
         write(1,302)  ' | Valeur moy. de E(B-V) : ', EBmV_moy
         write(1,302)  ' | Ec. type    de E(B-V) : ', Sig_EBmV
 302     format(A27,F6.3)
        end if
        write(1,3001) ' | Err. Max. B      : ', err_max_B
        write(1,3001) ' | Err. Max. V      : ', err_max_V
 3003  format(A26,I8)
        write(1,3002) ' | Nbr. d''objets    :', nobj
 3002   format(A22,I8)
 3001   format(A22,F9.4)
        write(1,4000) ' | Galaxie          : ', galax
 4000   format(A22,A3)
        write(1,11) ' **************************************************
     +************'
      close(1)

c Ecriture du fichier de sortie avec les couples (B-V), V
      open(1,status='unknown',form='formatted',
     +     file=filename_out(:long(filename_out)))
      print*, ' '
      print*, ' * Ecriture du fichier de sortie : ', 
     +        filename_out(:long(filename_out))
      print*, ' '
      do i= 1, nobj
         write(1,1111) grdobj(i,1), grdobj(i,2)
 1111    format(1p,2d16.6)
      end do
      close(1)
      print*, ' * Il y a : ', nobj, ' dans ce fichier de sortie'
      print*, ' '
      return

      end

c----------------------------------------------------------------
 
        function long(a)
 
c       Determination de la longueur effective d'une chaine
 
c       Auteur: G.Gonczi, Departement J.D. Cassini, O.C.A., Observatoire de Nice
c       version: 03 06 91
 
        implicit none
 
        integer*4 long
 
        character*(*)a
 
        long=len(a)
 
        do while(a(long:long) .eq. ' ' .and. long .gt. 1)
         long=long-1
        enddo
 
        return
 
        end
         
